\name{ace_score}
\alias{ace_score}
\title{
Adverse Childhood Experiences (ACE) Score
}
\description{
Calculates the Adverse Childhood Experiences (ACE) Score based on the 10-item survey from the CDC-Kaiser Permanente ACE Study. The score sums the number of categories of adverse experiences reported during the first 18 years of life. Higher scores are strongly correlated with negative health and behavioral outcomes later in life.
}
\usage{
ace_score(emotional_abuse, physical_abuse, sexual_abuse, emotional_neglect,
          physical_neglect, divorce_separation, domestic_violence,
          substance_abuse, mental_illness, incarcerated_relative)
}
\arguments{
  \item{emotional_abuse}{
Numeric (0 or 1). Did a parent or adult in the household often swear at, insult, put down, or humiliate you? (1 = Yes).
}
  \item{physical_abuse}{
Numeric (0 or 1). Did a parent or adult in the household often push, grab, slap, or throw something at you? (1 = Yes).
}
  \item{sexual_abuse}{
Numeric (0 or 1). Did an adult or person at least 5 years older than you ever touch or fondle you or have you touch their body in a sexual way? (1 = Yes).
}
  \item{emotional_neglect}{
Numeric (0 or 1). Did you often feel that no one in your family loved you or thought you were important? (1 = Yes).
}
  \item{physical_neglect}{
Numeric (0 or 1). Did you often feel that you didn't have enough to eat, had to wear dirty clothes, or had no one to protect you? (1 = Yes).
}
  \item{divorce_separation}{
Numeric (0 or 1). Were your parents ever separated or divorced? (1 = Yes).
}
  \item{domestic_violence}{
Numeric (0 or 1). Was your mother or stepmother often pushed, grabbed, slapped, or had something thrown at her? (1 = Yes).
}
  \item{substance_abuse}{
Numeric (0 or 1). Did you live with anyone who was a problem drinker or alcoholic, or who used street drugs? (1 = Yes).
}
  \item{mental_illness}{
Numeric (0 or 1). Was a household member depressed or mentally ill, or did a household member attempt suicide? (1 = Yes).
}
  \item{incarcerated_relative}{
Numeric (0 or 1). Did a household member go to prison? (1 = Yes).
}
}
\value{
A list containing:
\item{Total_Score}{The sum of affirmative answers (Range 0-10).}
\item{Interpretation}{General risk assessment associated with the score count.}
}
\references{
Felitti VJ, Anda RF, Nordenberg D, et al. Relationship of childhood abuse and household dysfunction to many of the leading causes of death in adults. The Adverse Childhood Experiences (ACE) Study. Am J Prev Med. 1998;14(4):245-258. doi:10.1016/s0749-3797(98)00017-8
}
\examples{

# Example 1: High Risk
# Divorce, Substance Abuse, Mental Illness, Incarceration
ace_score(0, 0, 0, 0, 0, 1, 0, 1, 1, 1)

# Example 2: Low Risk
# No adverse experiences reported
ace_score(0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
}
