% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_gifti.R
\name{smooth_gifti}
\alias{smooth_gifti}
\alias{smoothGIfTI}
\alias{smoothgii}
\title{Smooth a metric GIFTI file}
\usage{
smooth_gifti(
  original_fname,
  target_fname,
  surf_fname = NULL,
  surf_FWHM = 5,
  hemisphere = c("left", "right"),
  ROI_fname = NULL,
  zeroes_as_NA = FALSE
)

smoothGIfTI(
  original_fname,
  target_fname,
  surf_fname,
  surf_FWHM = 5,
  zeroes_as_NA = FALSE
)

smoothgii(
  original_fname,
  target_fname,
  surf_fname,
  surf_FWHM = 5,
  zeroes_as_NA = FALSE
)
}
\arguments{
\item{original_fname}{The GIFTI file to smooth.}

\item{target_fname}{Where to save the smoothed file.}

\item{surf_fname}{Surface GIFTI files cortical surface along which to smooth.
If not provided, the default inflated surfaces will be used.}

\item{surf_FWHM}{The full width at half maximum (FWHM) parameter
for the gaussian surface smoothing kernel, in mm. Default: \code{5}}

\item{hemisphere}{The cortex hemisphere: \code{"left"} or \code{"right"}.
Only used if \code{surf_fname} is \code{NULL}.}

\item{ROI_fname}{The ROI to limit smoothing to, as a metric file. This is
used to exclude the medial wall from smoothing. If not provided (default)
all the data is smoothed across the surface.}

\item{zeroes_as_NA}{Should zero-values be treated as NA? Default: \code{FALSE}.}
}
\value{
The smoothed GIFTI file name, invisibly
}
\description{
Smooths metric GIFTI data along the cortical surface. The results are written
to a new GIFTI file.
}
\section{Connectome Workbench}{

This function interfaces with the \code{"-metric-smoothing"} Workbench command.
}

\seealso{
Other gifting: 
\code{\link{remap_gifti}()},
\code{\link{resample_gifti}()}
}
\concept{gifting}
