% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/move_submask.R
\name{move_from_submask}
\alias{move_from_submask}
\title{Move data locations from subcortex mask}
\usage{
move_from_submask(
  xifti,
  new_mask,
  value = NA,
  label_value = "Other",
  name = "Other",
  RGBA = c(1, 1, 1, 0)
)
}
\arguments{
\item{xifti}{A \code{"xifti"} object.}

\item{new_mask}{The new mask, of which the current mask should be a subset.
(\code{new_mask} should have more \code{TRUE} values.) The new \code{TRUE}
values will be moved to the subcortex data.}

\item{value}{The value to assign the new locations. Default: \code{NA}.}

\item{label_value}{The label value to assign the new locations. Default:
\code{"Other"}.}

\item{name, RGBA}{Only used if the \code{"xifti"} has the dlabel intent and
\code{value} is not an already-existing Key. This is the name to assign to
the new key for the new locations, as well as a length-four numeric
vector indicating the red, green, blue, and alpha values for the color to
assign to the new key. These will be reflected in the updated label table.
Note that RGBA values must all be in [0, 1].

Currently, only one name and set of RGBA values are supported, meaning that
the out-of-mask subcortex locations will have the same Key, name, and color
across all data columns in the \code{"xifti"}. An error will occur if the
Key already exists for some columns but not others.

Defaults: \code{"Other"} for \code{"name"} and white with 0 alpha for
\code{RGBA}.}
}
\value{
The \code{"xifti"} with re-organized data and subcortex masks
}
\description{
Move subcortex mask locations into the subcortex data matrix by assigning
them a specific value (e.g. NA).
}
\seealso{
move_to_submask

unmask_cortex
}
