% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{anteriors}
\alias{anteriors}
\title{Get anteriors of nodes in a \code{caugi}}
\usage{
anteriors(cg, nodes = NULL, index = NULL)
}
\arguments{
\item{cg}{A \code{caugi} object of class DAG or PDAG.}

\item{nodes}{A vector of node names, a vector of unquoted
node names, or an expression combining these with \code{+} and \code{c()}.}

\item{index}{A vector of node indexes.}
}
\value{
Either a character vector of node names (if a single node is
requested) or a list of character vectors (if multiple nodes are requested).
}
\description{
Get the anterior set of nodes in a graph. The anterior set (Richardson and
Spirtes, 2002) includes all nodes reachable by following paths where every
edge is either undirected or directed toward the target node.

For DAGs, the anterior set equals the ancestor set (since there are no
undirected edges). For PDAGs, it includes both ancestors and nodes reachable
via undirected edges.
}
\examples{
# PDAG example with directed and undirected edges
cg <- caugi(
  A \%-->\% B \%---\% C,
  B \%-->\% D,
  class = "PDAG"
)
anteriors(cg, "A") # NULL (no anteriors)
anteriors(cg, "C") # A, B
anteriors(cg, "D") # A, B, C

# For DAGs, anteriors equals ancestors
cg_dag <- caugi(
  A \%-->\% B \%-->\% C,
  class = "DAG"
)
anteriors(cg_dag, "C") # A, B

}
\references{
Richardson, T. and Spirtes, P. (2002). Ancestral graph Markov models.
\emph{The Annals of Statistics}, 30(4):962-1030.
}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{districts}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_admg}()},
\code{\link{is_ag}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_mag}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{m_separated}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{same_nodes}()},
\code{\link{spouses}()},
\code{\link{subgraph}()},
\code{\link{topological_sort}()}
}
\concept{queries}
