% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_predictors.R
\name{add_predictors}
\alias{add_predictors}
\alias{get_predictors}
\title{Add predictors to \code{sdm_area}}
\usage{
add_predictors(sa, pred, variables_selected = NULL, gdal = TRUE)

get_predictors(i)
}
\arguments{
\item{sa}{A \code{sdm_area} object.}

\item{pred}{\code{RasterStack}, \code{SpatRaster}, \code{stars} or \code{sf} object with predictors
data.}

\item{variables_selected}{\code{character} vector with variables names in \code{pred} to be used
as predictors. If \code{NULL} adds all variables.}

\item{gdal}{Boolean. Force the use or not of GDAL when available. See details.}

\item{i}{\code{input_sdm} or \code{sdm_area} object to retrieve data from.}
}
\value{
For \code{add_predictors} the same input \code{sdm_area} object is returned including the
\code{pred} data binded to the previous \code{grid}.
\code{get_predictors} retrieves the grid from the \code{i} object.
}
\description{
This function includes new predictors to the \code{sdm_area} object.
}
\details{
\code{add_predictors} returns a \code{sdm_area} object with a grid built upon the \code{x} parameter.
There are two ways to make the grid and resample the variables in \code{sdm_area}: with and
without gdal. As standard, if gdal is available in you machine it will be used (\code{gdal = TRUE}),
otherwise sf/stars will be used.
}
\examples{
# Create sdm_area object:
sa <- sdm_area(parana, cell_size = 25000, crs = 6933)

# Include predictors:
sa <- add_predictors(sa, bioc)

# Retrieve predictors data:
get_predictors(sa)

}
\seealso{
\code{\link{sdm_area} \link{predictors} \link{bioc}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com) and Reginaldo Ré.
https://luizfesser.wordpress.com
}
