% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KMeansCluster.R
\name{axe-KMeansCluster}
\alias{axe-KMeansCluster}
\alias{axe_call.KMeansCluster}
\alias{axe_fitted.KMeansCluster}
\title{Axing a KMeansCluster.}
\usage{
\method{axe_call}{KMeansCluster}(x, verbose = FALSE, ...)

\method{axe_fitted}{KMeansCluster}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed KMeansCluster object.
}
\description{
Axing a KMeansCluster.
}
\examples{
\dontshow{if (rlang::is_installed("ClusterR")) withAutoprint(\{ # examplesIf}
library(ClusterR)
data(dietary_survey_IBS)
dat <- scale(dietary_survey_IBS[, -ncol(dietary_survey_IBS)])
km <- KMeans_rcpp(dat, clusters = 2, num_init = 5)
out <- butcher(km, verbose = TRUE)
\dontshow{\}) # examplesIf}
}
