% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_interpol.R
\name{interpol_yellow_notice}
\alias{interpol_yellow_notice}
\title{Get an Interpol yellow notice}
\usage{
interpol_yellow_notice(
  notice_id,
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{notice_id}{Notice ID.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with notice details.
}
\description{
Get an Interpol yellow notice
}
\details{
Returns detailed data for a yellow notice.
Official docs: https://interpol.api.bund.dev.
}
\examples{
\dontrun{
interpol_yellow_notice("2014-5590")
}

}
