% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc_strrep.R
\name{bc_strrep}
\alias{bc_strrep}
\alias{bc_strrep,ANY-method}
\title{Broadcasted strrep}
\usage{
bc_strrep(x, y, ...)

\S4method{bc_strrep}{ANY}(x, y)
}
\arguments{
\item{x}{vector/array of type \code{character}.}

\item{y}{vector/array of type \code{integer}.}

\item{...}{further arguments passed to or from methods. \cr \cr}
}
\value{
A character array as a result of the broadcasted repetition operation. \cr \cr
}
\description{
The \code{bc_strrep()} method
is a broadcasted form of \link[base]{strrep}. \cr \cr
}
\examples{

x <- array(sample(month.abb), c(10, 2))
y <- array(sample(1:10), c(10, 2, 3))

print(x)
print(y)

bc_strrep(x, y)
}
