% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warehouses.R
\name{db_sql_warehouse_create}
\alias{db_sql_warehouse_create}
\title{Create Warehouse}
\usage{
db_sql_warehouse_create(
  name,
  cluster_size,
  min_num_clusters = 1,
  max_num_clusters = 1,
  auto_stop_mins = 30,
  tags = list(),
  spot_instance_policy = c("COST_OPTIMIZED", "RELIABILITY_OPTIMIZED"),
  enable_photon = TRUE,
  warehouse_type = c("CLASSIC", "PRO"),
  enable_serverless_compute = NULL,
  disable_uc = FALSE,
  channel = c("CHANNEL_NAME_CURRENT", "CHANNEL_NAME_PREVIEW"),
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{name}{Name of the SQL warehouse. Must be unique.}

\item{cluster_size}{Size of the clusters allocated to the warehouse. One of
\verb{2X-Small}, \code{X-Small}, \code{Small}, \code{Medium}, \code{Large}, \code{X-Large}, \verb{2X-Large},
\verb{3X-Large}, \verb{4X-Large}.}

\item{min_num_clusters}{Minimum number of clusters available when a SQL
warehouse is running. The default is 1.}

\item{max_num_clusters}{Maximum number of clusters available when a SQL
warehouse is running. If multi-cluster load balancing is not enabled,
this is limited to 1.}

\item{auto_stop_mins}{Time in minutes until an idle SQL warehouse terminates
all clusters and stops. Defaults to 30. For Serverless SQL warehouses
(\code{enable_serverless_compute} = \code{TRUE}), set this to 10.}

\item{tags}{Named list that describes the warehouse. Databricks tags all
warehouse resources with these tags.}

\item{spot_instance_policy}{The spot policy to use for allocating instances
to clusters. This field is not used if the SQL warehouse is a Serverless SQL
warehouse.}

\item{enable_photon}{Whether queries are executed on a native vectorized
engine that speeds up query execution. The default is \code{TRUE}.}

\item{warehouse_type}{Either "CLASSIC" (default), or "PRO"}

\item{enable_serverless_compute}{Whether this SQL warehouse is a Serverless
warehouse. To use a Serverless SQL warehouse, you must enable Serverless SQL
warehouses for the workspace. If Serverless SQL warehouses are disabled for the
workspace, the default is \code{FALSE} If Serverless SQL warehouses are enabled for
the workspace, the default is \code{TRUE}.}

\item{disable_uc}{If \code{TRUE} will use Hive Metastore (HMS). If \code{FALSE}
(default), then it will be enabled for Unity Catalog (UC).}

\item{channel}{Whether to use the current SQL warehouse compute version or the
preview version. Databricks does not recommend using preview versions for
production workloads. The default is \code{CHANNEL_NAME_CURRENT.}}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Create Warehouse
}
\seealso{
Other Warehouse API: 
\code{\link{db_sql_global_warehouse_get}()},
\code{\link{db_sql_warehouse_delete}()},
\code{\link{db_sql_warehouse_edit}()},
\code{\link{db_sql_warehouse_get}()},
\code{\link{db_sql_warehouse_list}()},
\code{\link{db_sql_warehouse_start}()},
\code{\link{db_sql_warehouse_stop}()},
\code{\link{get_and_start_warehouse}()}
}
\concept{Warehouse API}
