% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saspoint5_distribution.R
\name{saspoint5_distribution}
\alias{saspoint5_distribution}
\alias{saspoint5_pdf}
\alias{saspoint5_lpdf}
\alias{saspoint5_cdf}
\alias{saspoint5_lcdf}
\alias{saspoint5_quantile}
\title{S\eqn{\alpha}S Point5 Distribution Functions}
\usage{
saspoint5_distribution(location = 0, scale = 1)

saspoint5_pdf(x, location = 0, scale = 1)

saspoint5_lpdf(x, location = 0, scale = 1)

saspoint5_cdf(x, location = 0, scale = 1)

saspoint5_lcdf(x, location = 0, scale = 1)

saspoint5_quantile(p, location = 0, scale = 1)
}
\arguments{
\item{location}{location parameter (default is 0)}

\item{scale}{scale parameter (default is 1)}

\item{x}{quantile}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the S\eqn{\alpha}S Point5 distribution.
}
\examples{
# SaS Point5 distribution with location 0 and scale 1
dist <- saspoint5_distribution(0, 1)
# Apply generic functions
cdf(dist, 0.5)
logcdf(dist, 0.5)
pdf(dist, 0.5)
logpdf(dist, 0.5)
hazard(dist, 0.5)
chf(dist, 0.5)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
support(dist)

# Convenience functions
saspoint5_pdf(3)
saspoint5_lpdf(3)
saspoint5_cdf(3)
saspoint5_lcdf(3)
saspoint5_quantile(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/saspoint5_dist.html}{Boost Documentation} for more details on the mathematical background.
}
