% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_df.R
\name{names<-.sim_df}
\alias{names<-.sim_df}
\title{Set the column names of a SIM data frame}
\usage{
\method{names}{sim_df}(x) <- value
}
\arguments{
\item{x}{data frame of spatial interaction models, an object of class
\code{sim_df}}

\item{value}{unique names for the columns of the data frame}
}
\value{
a \code{sim_df} data frame if possible, a standard \code{data.frame} when
this is not possible.
}
\description{
Set the column names of a SIM data frame. Renaming the \code{sim_list} column is
supported and tracked, but renaming any core column turns the \code{sim_df}
into a standard \code{data.frame}.
}
\examples{
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- rep(1, 10)
attractiveness <- log(french_cities$area[1:10])
all_flows <- grid_blvim(distances, production, seq(1.05, 1.45, by = 0.2),
  seq(1, 3, by = 0.5) / 400,
  attractiveness,
  bipartite = FALSE,
  epsilon = 0.1, iter_max = 1000,
)
all_flows_df <- sim_df(all_flows)
names(all_flows_df)
names(all_flows_df)[6] <- "my_sim"
names(all_flows_df)
## still a sim_df
class(all_flows_df)
names(all_flows_df)[1] <- "return to scale"
names(all_flows_df)
## not a sim_df
class(all_flows_df)
}
