% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{summarise_te_top3_posthoc}
\alias{summarise_te_top3_posthoc}
\title{Summarise top-3 transfer entropy results (global)}
\usage{
summarise_te_top3_posthoc(te_tab, dir_csv)
}
\arguments{
\item{te_tab}{Optional data frame with transfer entropy results,
containing at least columns \code{lag}, \code{TE_ItoC},
\code{TE_CtoI}, \code{p_ItoC}, \code{p_CtoI}, and optionally
\code{type}. If \code{NULL} or empty, the function attempts to read
the data from CSV files via the internal helper \code{.read_te_all()}.}

\item{dir_csv}{Character scalar; directory where the transfer entropy
CSV files are stored (used when \code{te_tab} is missing).}
}
\value{
A data frame with up to three rows and columns:
\itemize{
\item \code{model}: constant string \code{"TransferEntropy"}.
\item \code{config}: textual description of direction, lag, and,
if available, type (counts, rates, binary).
\item \code{stat}: transfer entropy estimate.
\item \code{p_value}: associated p-value.
}
If no results are available, a single-row data frame with \code{NA}
entries is returned.
}
\description{
Produces a compact summary of the three most statistically significant
transfer entropy estimates across directions and lags, optionally
combining information from counts, rates, and binary specifications.
}
\details{
The function reshapes \code{te_tab} into a long format with directions
\code{"I->C"} and \code{"C->I"}, orders by p-value (ascending) and
lag, and keeps the three rows with the smallest p-values.
}
