% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design-matrix.R
\name{build_design}
\alias{build_design}
\title{Build Design Matrices for Bivariate Hurdle Model}
\usage{
build_design(
  DT,
  k,
  include_C_to_I = TRUE,
  include_I_to_C = TRUE,
  include_trend = TRUE,
  controls = character(0),
  include_regimes = TRUE,
  include_transitions = TRUE
)
}
\arguments{
\item{DT}{A data.table with required columns.}

\item{k}{Integer; lag order.}

\item{include_C_to_I}{Logical; include C lags in I equations.}

\item{include_I_to_C}{Logical; include I lags in C equations.}

\item{include_trend}{Logical; include polynomial time trend.}

\item{controls}{Character vector of control variable names.}

\item{include_regimes}{Logical; include regime dummies.}

\item{include_transitions}{Logical; include transition dummies.}
}
\value{
A list containing design matrices and outcome vectors.
}
\description{
Constructs design matrices for the zero and count components
of both outcome variables with cross-lags, trends, regimes,
transition dummies, and control variables.
}
