% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_qsig}
\alias{add_qsig}
\title{Add BH-adjusted q-values and significance stars}
\usage{
add_qsig(df)
}
\arguments{
\item{df}{A data frame containing at least a numeric column
\code{p_value}. If \code{df} is \code{NULL} or has zero rows,
it is returned unchanged.}
}
\value{
The input data frame with added columns \code{q_value} and
\code{sig}. If \code{df} is \code{NULL} or empty, it is returned as is.
}
\description{
Adds Benjamini-Hochberg adjusted q-values and a simple significance
code column based on p-values contained in a data frame.
}
\details{
The function:
\itemize{
\item Computes \code{q_value} using \code{p.adjust(method = "BH")}.
\item Creates a \code{sig} column with significance codes:
\itemize{
\item \code{"***"} for \code{q_value <= 0.001}
\item \code{"**"}  for \code{0.001 < q_value <= 0.01}
\item \code{"*"}   for \code{0.01 < q_value <= 0.05}
\item \code{""}    otherwise
}
}
}
