% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-big_pls.R
\name{predict.big_pls_cox}
\alias{predict.big_pls_cox}
\alias{predict.big_pls_cox_gd}
\title{Predict method for big-memory PLS-Cox models}
\usage{
\method{predict}{big_pls_cox}(
  object,
  newdata = NULL,
  type = c("link", "risk", "response", "components"),
  comps = NULL,
  coef = NULL,
  ...
)

\method{predict}{big_pls_cox_gd}(
  object,
  newdata = NULL,
  type = c("link", "risk", "response", "components"),
  comps = NULL,
  coef = NULL,
  ...
)
}
\arguments{
\item{object}{A model fitted with \code{\link[=big_pls_cox]{big_pls_cox()}}.}

\item{newdata}{Optional matrix, data frame or \code{\link[bigmemory:big.matrix]{bigmemory::big.matrix}}
containing predictors to project on the latent space. When \code{NULL} the
training scores are used.}

\item{type}{Type of prediction: \code{"link"} for the linear predictor, \code{"risk"}
or \code{"response"} for the exponential of the linear predictor, or
\code{"components"} to obtain latent scores.}

\item{comps}{Integer vector indicating which components to use. Defaults to
all available components.}

\item{coef}{Optional coefficient vector overriding the fitted Cox model
coefficients.}

\item{...}{Unused.}
}
\value{
Depending on \code{type}, either a numeric vector of predictions or a
matrix of component scores.
}
\description{
Predict method for big-memory PLS-Cox models
}
\references{
Maumy, M., Bertrand, F. (2023). PLS models and their extension for big data.
Joint Statistical Meetings (JSM 2023), Toronto, ON, Canada.

Maumy, M., Bertrand, F. (2023). bigPLS: Fitting and cross-validating
PLS-based Cox models to censored big data. BioC2023 — The Bioconductor
Annual Conference, Dana-Farber Cancer Institute, Boston, MA, USA.
Poster. https://doi.org/10.7490/f1000research.1119546.1

Bastien, P., Bertrand, F., Meyer, N., & Maumy-Bertrand, M. (2015).
Deviance residuals-based sparse PLS and sparse kernel PLS for censored
data. \emph{Bioinformatics}, 31(3), 397–404. \url{doi:10.1093/bioinformatics/btu660}

Bertrand, F., Bastien, P., Meyer, N., & Maumy-Bertrand, M. (2014). PLS
models for censored data. In \emph{Proceedings of UseR! 2014} (p. 152).
}
\seealso{
\code{\link[=big_pls_cox]{big_pls_cox()}}, \code{\link[=big_pls_cox_gd]{big_pls_cox_gd()}}, \code{\link[=select_ncomp]{select_ncomp()}},
\code{\link[=computeDR]{computeDR()}}.
}
