% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{vcov.brs}
\alias{vcov.brs}
\title{Variance-covariance matrix of estimated coefficients}
\usage{
\method{vcov}{brs}(object, model = c("full", "mean", "precision"), ...)
}
\arguments{
\item{object}{A fitted \code{"betaregscale"} object.}

\item{model}{Character: which component (\code{"full"},
\code{"mean"}, or \code{"precision"}).}

\item{...}{Ignored.}
}
\value{
A square numeric matrix.
}
\description{
Variance-covariance matrix of estimated coefficients
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
vcov(fit)
vcov(fit, model = "mean")
}

}
\seealso{
\code{\link{brs}}, \code{\link{coef.brs}}, \code{\link{confint.brs}}
}
