% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{formula.brs}
\alias{formula.brs}
\title{Extract model formula}
\usage{
\method{formula}{brs}(x, ...)
}
\arguments{
\item{x}{A fitted \code{"betaregscale"} object.}

\item{...}{Ignored.}
}
\value{
The formula used to fit the model.
}
\description{
Extract model formula
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
formula(fit)
}

}
\seealso{
\code{\link{brs}}, \code{\link{model.matrix.brs}},
  \code{\link{coef.brs}}
}
