% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{.brs_grad_fixed_cpp}
\alias{.brs_grad_fixed_cpp}
\title{C++ gradient for fixed-dispersion log-likelihood}
\usage{
.brs_grad_fixed_cpp(
  param,
  X,
  y_left,
  y_right,
  yt,
  delta,
  link_mu_code,
  link_phi_code,
  repar
)
}
\arguments{
\item{param}{Parameter vector (same layout as loglik function).}

\item{X}{Design matrix (n x p).}

\item{y_left}{Left endpoints.}

\item{y_right}{Right endpoints.}

\item{yt}{Midpoint responses.}

\item{delta}{Integer censoring indicators.}

\item{link_mu_code}{Integer mean link code.}

\item{link_phi_code}{Integer dispersion link code.}

\item{repar}{Integer reparameterization type.}
}
\value{
Numeric gradient vector of length \code{ncol(X) + 1}.
}
\description{
Returns the gradient vector of the log-likelihood with
  respect to all parameters (beta coefficients + scalar phi), using
  a central-difference numerical approximation (step = 1e-6).
}
\keyword{internal}
