% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_bw.R
\name{boot_bw}
\alias{boot_bw}
\alias{boot_bw_parallel}
\alias{boot_bw_sequential}
\alias{boot_bw_weight}
\alias{boot_bw_sample_clusters}
\alias{boot_bw_sample_within_clusters}
\title{Blocked Weighted Bootstrap - vectorised and parallel}
\usage{
boot_bw(
  x,
  w,
  statistic,
  params,
  outputColumns = params,
  replicates = 400,
  strata = NULL,
  parallel = FALSE,
  cores = parallelly::availableCores(omit = 1)
)

boot_bw_parallel(
  x,
  w,
  statistic,
  params,
  outputColumns = params,
  replicates = 400,
  strata = NULL,
  cores = parallelly::availableCores(omit = 1)
)

boot_bw_sequential(
  x,
  w,
  statistic,
  params,
  outputColumns = params,
  replicates = 400,
  strata = NULL
)

boot_bw_weight(w)

boot_bw_sample_clusters(x, w, index = FALSE)

boot_bw_sample_within_clusters(cluster_df)
}
\arguments{
\item{x}{A \code{\link[=data.frame]{data.frame()}} with primary sampling unit (PSU) in variable named
\code{psu} and at least one other variable containing data for estimation.}

\item{w}{A \code{\link[=data.frame]{data.frame()}} with primary sampling unit (PSU) in variable named
\code{psu} and survey weights (i.e. PSU population) in variable named \code{pop}.}

\item{statistic}{Am estimator function operating on variables in \code{x}
containing data for estimation. The functions \code{\link[=bootClassic]{bootClassic()}} and
\code{\link[=bootPROBIT]{bootPROBIT()}} are examples.}

\item{params}{Parameters specified as names of columns in \code{x} that are to be
passed to the function specified in \code{statistic}.}

\item{outputColumns}{Names to be used for columns in output \code{\link[=data.frame]{data.frame()}}.
Default to names specified in \code{params}.}

\item{replicates}{Number of bootstrap replicates to be performed. Default is
400.}

\item{strata}{A character value for name of variable in \code{x} providing
information on how \code{x} is grouped such that resampling is performed for
each group. Default to NULL for no grouping and resampling is performed for
full data.}

\item{parallel}{Logical. Should resampling be done in parallel? Default to
FALSE.}

\item{cores}{The number of computer cores to use or number of child processes
to be run simultaneously. Default to one less than the available number of
cores on current machine.}

\item{index}{Logical. Should index values be returned or a list of
\code{\link[=data.frame]{data.frame()}}s. Default to FALSE.}

\item{cluster_df}{A list of \code{\link[=data.frame]{data.frame()}}s for selected clusters.}
}
\value{
For \code{\link[=boot_bw]{boot_bw()}}, a \code{\link[=data.frame]{data.frame()}} with number of columns equal to
length of \code{outputColumns}; number of rows equal to number of \code{replicates};
and, names of variables equal to values of \code{outputColumns}. For
\code{\link[=boot_bw_weight]{boot_bw_weight()}}, A \code{\link[=data.frame]{data.frame()}} based on \code{w} with two additional
variables for \code{weight} and \code{cumWeight}. For \code{\link[=boot_bw_sample_clusters]{boot_bw_sample_clusters()}},
either a vector of integers corresponding to the primary sampling unit
(psu) identifier of the selected clusters (when \code{index = TRUE}) or a list
of \code{\link[=data.frame]{data.frame()}}s corresponding to the data for the selected clusters
(when \code{index = FALSE}). For \code{\link[=boot_bw_sample_within_clusters]{boot_bw_sample_within_clusters()}}, a matrix
similar in structure to  \code{x} of resampled data from each selected cluster.
}
\description{
This set of functions is an alternative to the \code{\link[=bootBW]{bootBW()}} function. This set
attempts to make the blocked weighted bootstrap algorithm more efficient
through vectorisation and use of parallelisation techniques. The function
syntax has been kept consistent with \code{\link[=bootBW]{bootBW()}} for ease of transition. A
more in depth discussion of the efficiencies gained from this alternative
function is discussed here.
}
\examples{
boot_bw(
  x = indicatorsHH, w = villageData, statistic = bootClassic, 
  params = "anc1", replicates = 9, parallel = TRUE
)

}
