% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relation_schema.r
\name{relation_schema}
\alias{relation_schema}
\title{Relation schema vectors}
\usage{
relation_schema(schemas, attrs_order)
}
\arguments{
\item{schemas}{a named list of schemas, in the form of two-element lists: the
first element contains a character vector of all attributes in the relation
schema, and the second element contains a list of character vectors,
each representing a candidate key.}

\item{attrs_order}{a character vector, giving the names of all attributes.
These need not be present in \code{schemas}, but all attributes in
\code{schemas} must be present in \code{attrs_order}.}
}
\value{
A \code{relation_schema} object, containing the list given in
\code{schemas}, with \code{attrs_order} stored in an attribute of the same
name. Relation schemas are returned with their keys' attributes sorted
according to the attribute order in \code{attrs_order}, and the keys then
sorted by priority order. Attributes in the schema are also sorted, first
by order of appearance in the sorted keys, then by order in
\code{attrs_order} for non-prime attributes.
}
\description{
Creates a set of relation schemas, including the relation's attributes and
candidate keys.
}
\details{
Duplicate schemas, after ordering by attribute, are allowed, and can be
removed with \verb{\code{\link{unique}}}.

When several sets of relation schemas are concatenated, their
\code{attrs_order} attributes are merged, so as to preserve all of the original
attribute orders, if possible. If this is not possible, because the orderings
disagree, then the returned value of the \code{attrs_order} attribute is their
union instead.
}
\examples{
schemas <- relation_schema(
  list(
    a = list(c("a", "b"), list("a")),
    b = list(c("b", "c"), list("b", "c"))
  ),
  attrs_order = c("a", "b", "c", "d")
)
print(schemas)
attrs(schemas)
keys(schemas)
attrs_order(schemas)
names(schemas)

# vector operations
schemas2 <- relation_schema(
  list(
    e = list(c("a", "e"), list("e"))
  ),
  attrs_order = c("a", "e")
)
c(schemas, schemas2) # attrs_order attributes are merged
unique(c(schemas, schemas))

# subsetting
schemas[1]
schemas[c(1, 2, 1)]
stopifnot(identical(schemas[[1]], schemas[1]))

# reassignment
schemas3 <- schemas
schemas3[2] <- relation_schema(
  list(d = list(c("d", "c"), list("d"))),
  attrs_order(schemas3)
)
print(schemas3) # note the schema's name doesn't change
# names(schemas3)[2] <- "d" # this would change the name
keys(schemas3)[[2]] <- list(character()) # removing keys first...
attrs(schemas3)[[2]] <- c("b", "c") # so we can change the attrs legally
keys(schemas3)[[2]] <- list("b", "c") # add the new keys
stopifnot(identical(schemas3, schemas))

# changing appearance priority for attributes
attrs_order(schemas3) <- c("d", "c", "b", "a")
print(schemas3)

# reconstructing from components
schemas_recon <- relation_schema(
  Map(list, attrs(schemas), keys(schemas)),
  attrs_order(schemas)
)
stopifnot(identical(schemas_recon, schemas))

# can be a data frame column
data.frame(id = 1:2, schema = schemas)
}
\seealso{
\code{\link{attrs}}, \code{\link{keys}}, and
\code{\link{attrs_order}} for extracting parts of the information in a
\code{relation_schema}; \code{\link{create}} for creating a
\code{\link{relation}} object that uses the given schema; \code{\link{gv}}
for converting the schema into Graphviz code; \code{\link{rename_attrs}}
for renaming the attributes in \code{attrs_order};
\code{\link{merge_empty_keys}} for combining relations with an empty key;
\code{\link{merge_schemas}} for combining relations with matching sets of
keys.
}
