% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agronomic_analysis.R
\name{thermal_indices}
\alias{thermal_indices}
\title{Growing Degree Days (GDD) and Thermal Indices}
\usage{
thermal_indices(
  tmax,
  tmin,
  base_temp = 10,
  sunshine_hours = NULL,
  day_length = NULL,
  crop_yield = NULL,
  biomass = NULL,
  verbose = TRUE
)
}
\arguments{
\item{tmax}{Vector of daily maximum temperatures (C)}

\item{tmin}{Vector of daily minimum temperatures (C)}

\item{base_temp}{Base temperature (C)}

\item{sunshine_hours}{Vector of daily sunshine hours (optional)}

\item{day_length}{Vector of day length in hours (optional)}

\item{crop_yield}{Crop yield for HUE calculation (optional)}

\item{biomass}{Biomass for HUE calculation (optional)}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List with thermal indices
}
\description{
Calculates Growing Degree Days, Helio-thermal Units, Photo-thermal Units,
and Heat Use Efficiency from temperature data.
}
\examples{
tmax <- runif(90, 30, 42)
tmin <- runif(90, 18, 28)
thermal_indices(tmax, tmin, base_temp = 10)

}
\author{
Lalit Kumar Rolaniya, Ram Lal Jat, Monika Punia, Raja Ram Choudhary
}
