% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed_conversion.R
\name{fce}
\alias{fce}
\title{Feed conversion efficiency (FCE)}
\usage{
fce(ibw, fbw, feed, dm = 1)
}
\arguments{
\item{ibw}{numeric; value that is providing the initial body weight in
grams.}

\item{fbw}{numeric; value that is providing the final body weight in
grams.}

\item{feed}{numeric; value providing the total feed fed in grams
during the experiment.}

\item{dm}{numeric; value indicating the dry matter content of the feed.
Value in the interval of (0:1). Default is 1.}
}
\value{
a numeric value that is the feed conversion efficiency (FCE)
}
\description{
A function that calculates the feed conversion efficiency (FCE), which is the
inverse of the feed conversion ratio (FCR). As FCR, this metric measures how
effectively cultivated species convert feed into weight. However, contrarily
to FCR, the higher the FCE the more efficient the feed conversion is.
}
\examples{
# Feed intake = 1500 g
# Feed dry matter = 0.96 g/g (= 96\%)
# Initial bodyweight = 100 g
# Final bodyweight = 1000 g

fce(100, 1000, 1500, 0.96)

}
\author{
Anıl Axel Tellbüscher

Davide A. Machado e Silva

Madhav Karthikeyan
}
