% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_points.R
\name{random_points}
\alias{random_points}
\alias{random_points.hr}
\alias{random_points.sf}
\alias{random_points.track_xy}
\title{Generate random points}
\usage{
random_points(x, ...)

\method{random_points}{hr}(x, n = 100, type = "random", presence = NULL, ...)

\method{random_points}{sf}(x, n = 100, type = "random", presence = NULL, ...)

\method{random_points}{track_xy}(x, level = 1, hr = "mcp", n = nrow(x) * 10, type = "random", ...)
}
\arguments{
\item{x}{\code{[track_xy, track_xyt]} \cr A track created with \code{make_track}.}

\item{...}{\verb{[any]}\cr None implemented.}

\item{n}{\verb{[integer(1)]} \cr The number of random points.}

\item{type}{\verb{[character(1)]} \cr Argument passed to \code{sf::st_sample}. The default is \code{random}.}

\item{presence}{\verb{[track]} \cr The presence points, that will be added to the result.}

\item{level}{\verb{[numeric(1)]} \cr Home-range level of the minimum convex polygon, used for generating the background samples.}

\item{hr}{\verb{[character(1)]} \cr The home range estimator to be used. Currently only "mcp" and "kde" are implemented.}
}
\value{
A \code{tibble} with the observed and random points and a new column \code{case_} that indicates if a point is observed (\code{case_ = TRUE}) or random (\verb{case_ TRUE}).
}
\description{
Functions to generate random points within an animals home range. This is usually the first step for investigating habitat selection via Resource Selection Functions (RSF).
}
\note{
For objects of class \code{track_xyt} the timestamp (\code{t_}) is lost.
}
\examples{

\donttest{
data(deer)

# track_xyt ---------------------------------------------------------------
# Default settings
rp1 <- random_points(deer)

plot(rp1)

# Ten random points for each observed point
rp <- random_points(deer, n = nrow(deer) * 10)
plot(rp)

# Within a home range -----------------------------------------------------
hr <- hr_mcp(deer, level = 1)

# 100 random point within the home range
rp <- random_points(hr, n = 100)
plot(rp)

# 100 regular point within the home range
rp <- random_points(hr, n = 100, type = "regular")
plot(rp)
# 100 hexagonal point within the home range
rp <- random_points(hr, n = 100, type = "hexagonal")
plot(rp)
}

}
