% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_narr}
\alias{process_narr}
\title{Process meteorological data}
\usage{
process_narr(
  date = "2023-09-01",
  variable = NULL,
  path = NULL,
  extent = NULL,
  ...
)
}
\arguments{
\item{date}{character(1 or 2). Date (1) or start and end dates (2).
Format YYYY-MM-DD (ex. September 1, 2023 = "2023-09-01").}

\item{variable}{character(1). Variable name acronym. See \href{https://ftp.cpc.ncep.noaa.gov/NARR/fixed/merged_land_AWIP32corrected.pdf}{List of Variables in NARR Files}
for variable names and acronym codes.}

\item{path}{character(1). Directory with downloaded netCDF (.nc) files.}

\item{extent}{numeric(4) or SpatExtent giving the extent of the raster
if \code{NULL} (default), the entire raster is loaded}

\item{...}{Placeholders.}
}
\value{
a \code{SpatRaster} object
}
\description{
The \code{process_narr()} function imports and cleans raw meteorological
data, returning a single \code{SpatRaster} object.
}
\note{
Layer names of the returned \code{SpatRaster} object contain the variable acronym,
pressure level, and date.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
process_narr(
  date = c("2018-01-01", "2018-01-10"),
  variable = "weasd",
  path = "./tests/testdata/narr/weasd"
)
}
}
\author{
Mitchell Manware
}
