% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alsi.R
\name{plot_subspace_stability}
\alias{plot_subspace_stability}
\title{Plot Subspace Stability Diagnostics}
\usage{
plot_subspace_stability(boot_obj)
}
\arguments{
\item{boot_obj}{Object of class \code{mca_bootstrap}}
}
\value{
No return value, called for side effects. The function creates 
  a two-panel figure with: (1) boxplots of principal angles (left panel), 
  showing the distribution of subspace similarity across bootstrap resamples 
  for each dimension; and (2) boxplots of Tucker congruence coefficients 
  (right panel), showing dimension-level replicability with reference lines 
  at phi = 0.85 (good) and phi = 0.95 (excellent).
}
\description{
Creates diagnostic plots showing distributions of principal angles
and Tucker congruence coefficients across bootstrap resamples.
}
\examples{
\donttest{
data(ANR2)
vars <- c("MDD", "DYS", "DEP", "PTSD", "OCD", "GAD", "ANX", "SOPH", "ADHD")
boot <- mca_bootstrap(ANR2, vars = vars, K = 3, B = 100)
plot_subspace_stability(boot)
}
}
