% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord-methods.r
\name{cross_product3d}
\alias{cross_product3d}
\title{Compute 3D vector cross product}
\usage{
cross_product3d(x, y)
}
\arguments{
\item{x}{A \link{Coord3D} class vector.}

\item{y}{A \link{Coord3D} class vector.}
}
\value{
A \link{Coord3D} class vector
}
\description{
\code{cross_product3d()} computes the cross product of two \link{Coord3D} class vectors.
}
\examples{
x <- as_coord3d(2, 3, 4)
y <- as_coord3d(5, 6, 7)
cross_product3d(x, y)
if (getRversion() >= "4.4.0") {
  crossprod(x, y)
}
}
