% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_bar}
\alias{plot_bar}
\title{plot_bar}
\usage{
plot_bar(
  df,
  x,
  y,
  z = NULL,
  base_size = 25,
  line_width = 1,
  text_color = "black",
  facet = FALSE,
  facet_x = NULL,
  facet_y = NULL,
  style = "bw",
  position = "dodge",
  stat = "identity"
)
}
\arguments{
\item{df}{A data frame.}

\item{x}{<[`data-masking`][ggplot2::aes]> Column mapped to the x-axis.}

\item{y}{<[`data-masking`][ggplot2::aes]> Column mapped to the y-axis.}

\item{z}{<[`data-masking`][ggplot2::aes]> Optional column mapped to fill colour.}

\item{base_size}{Base font size. Default 25.}

\item{line_width}{Bar outline width. Default 1.}

\item{text_color}{Text colour. Default \code{"black"}.}

\item{facet}{Logical; add facet grid? Default \code{FALSE}.}

\item{facet_x}{Column name (string) for the horizontal facet dimension.}

\item{facet_y}{Column name (string) for the vertical facet dimension.}

\item{style}{Theme style. Default \code{"bw"}.}

\item{position}{Bar position: \code{"dodge"} or \code{"stack"}. Default \code{"dodge"}.}

\item{stat}{Stat type: \code{"identity"} or \code{"count"}. Default \code{"identity"}.}
}
\value{
A \code{ggplot} object.
}
\description{
Create a bar plot using the aelab theme.
}
\examples{
\dontrun{
df <- data.frame(x = c("A","B","A","B"), g = c("X","X","Y","Y"), y = c(1,2,3,4))
plot_bar(df, x, y, g)
}
}
