% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_query_data.R
\name{query}
\alias{query}
\title{Create an \code{query} object}
\usage{
query(prefix, name = auto, id = NULL, add_scope_num = FALSE, definition = NULL)
}
\arguments{
\item{prefix}{The value is used to populate \code{PREFIX} in the output
dataset of \code{create_query_data()}, e.g., \code{"SMQ03"}

\describe{
\item{Default value}{none}
}}

\item{name}{The value is used to populate \code{GRPNAME} in the output dataset
of \code{create_query_data()}. If the \code{auto} keyword is specified, the variable
is set to the name of the query in the SMQ/SDG database.

\describe{
\item{Permitted values}{A character scalar or the \code{auto} keyword. The \code{auto}
keyword is permitted only for queries which are defined by an
\code{basket_select()} object.}
\item{Default value}{\code{auto}}
}}

\item{id}{The value is used to populate \code{GRPID} in the output dataset of
\code{create_query_data()}. If the \code{auto} keyword is specified, the variable is
set to the id of the query in the SMQ/SDG database.

\describe{
\item{Permitted values}{A integer scalar or the \code{auto} keyword. The \code{auto}
keyword is permitted only for queries which are defined by an
\code{basket_select()} object.}
\item{Default value}{\code{NULL}}
}}

\item{add_scope_num}{Determines if  \code{SCOPEN} in the output dataset
of \code{create_query_data()} is populated

If the parameter is set to \code{TRUE}, the definition must be an \code{basket_select()}
object.

\emph{Default}: \code{FALSE}

\describe{
\item{Permitted values}{\code{TRUE}, \code{FALSE}}
\item{Default value}{\code{FALSE}}
}}

\item{definition}{Definition of terms belonging to the query

There are three different ways to define the terms:
\itemize{
\item An \code{basket_select()} object is specified to select a query from the SMQ
database.
\item A data frame with columns \code{SRCVAR} and \code{TERMCHAR} or \code{TERMNUM} can
be specified to define the terms of a customized query. The \code{SRCVAR}
should be set to the name of the variable which should be used to select
the terms, e.g., \code{"AEDECOD"} or \code{"AELLTCD"}. \code{SRCVAR} does not need
to be constant within a query. For example a query can be based on
\code{AEDECOD} and \code{AELLT}.

If \code{SRCVAR} refers to a character variable, \code{TERMCHAR} should be set
to the value the variable. If it refers to a numeric variable, \code{TERMNUM}
should be set to the value of the variable. If only character variables
or only numeric variables are used, \code{TERMNUM} or \code{TERMCHAR} respectively
can be omitted.
\item A list of data frames and \code{basket_select()} objects can be specified to
define a customized query based on custom terms and SMQs. The data frames
must have the same structure as described for the previous item.
}

\describe{
\item{Permitted values}{an \code{basket_select()} object, a
data frame, or a list of data frames and \code{basket_select()} objects.}
\item{Default value}{\code{NULL}}
}}
}
\value{
An object of class \code{query}.
}
\description{
A \code{query} object defines a query, e.g., a Standard MedDRA Query (SMQ), a
Standardized Drug Grouping (SDG), or a customized query (CQ). It is used
as input to \code{create_query_data()}.
}
\examples{
# create a query for an SMQ
library(tibble)
library(dplyr, warn.conflicts = FALSE)

# create a query for a SMQ
query(
  prefix = "SMQ02",
  id = auto,
  definition = basket_select(
    name = "Pregnancy and neonatal topics (SMQ)",
    scope = "NARROW",
    type = "smq"
  )
)

# create a query for an SDG
query(
  prefix = "SDG01",
  id = auto,
  definition = basket_select(
    name = "5-aminosalicylates for ulcerative colitis",
    scope = NA_character_,
    type = "sdg"
  )
)

# creating a query for a customized query
cqterms <- tribble(
  ~TERMCHAR, ~TERMNUM,
  "APPLICATION SITE ERYTHEMA", 10003041L,
  "APPLICATION SITE PRURITUS", 10003053L
) \%>\%
  mutate(SRCVAR = "AEDECOD")

query(
  prefix = "CQ01",
  name = "Application Site Issues",
  definition = cqterms
)

# creating a customized query based on SMQs and additional terms
query(
  prefix = "CQ03",
  name = "Special issues of interest",
  definition = list(
    cqterms,
    basket_select(
      name = "Pregnancy and neonatal topics (SMQ)",
      scope = "NARROW",
      type = "smq"
    ),
    basket_select(
      id = 8050L,
      scope = "BROAD",
      type = "smq"
    )
  )
)
}
\seealso{
\code{\link[=create_query_data]{create_query_data()}}, \code{\link[=basket_select]{basket_select()}},
\code{vignette("queries_dataset")}

Source Objects:
\code{\link{basket_select}()},
\code{\link{censor_source}()},
\code{\link{death_event}},
\code{\link{event}()},
\code{\link{event_joined}()},
\code{\link{event_source}()},
\code{\link{flag_event}()},
\code{\link{records_source}()},
\code{\link{tte_source}()}
}
\concept{source_specifications}
\keyword{source_specifications}
