% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_crit_flag.R
\name{derive_vars_crit_flag}
\alias{derive_vars_crit_flag}
\title{Derive Criterion Flag Variables \code{CRITy}, \code{CRITyFL}, and \code{CRITyFN}}
\usage{
derive_vars_crit_flag(
  dataset,
  crit_nr = 1,
  condition,
  description,
  values_yn = FALSE,
  create_numeric_flag = FALSE
)
}
\arguments{
\item{dataset}{Input dataset

\describe{
\item{Permitted values}{a dataset, i.e., a \code{data.frame} or tibble}
\item{Default value}{none}
}}

\item{crit_nr}{The criterion number, i.e., the \code{y} in \code{CRITy}

\describe{
\item{Permitted values}{a positive integer, e.g. \code{2} or \code{5}}
\item{Default value}{\code{1}}
}}

\item{condition}{Condition for flagging records

See description of the \code{values_yn} argument for details on how the
\code{CRITyFL} variable is populated.

\describe{
\item{Permitted values}{an unquoted condition, e.g., \code{AVISIT == "BASELINE"}}
\item{Default value}{none}
}}

\item{description}{The description of the criterion

The \code{CRITy} variable is set to the specified value.

An expression can be specified to set the value depending on the parameter.
Please note that the value must be constant within a parameter.

\describe{
\item{Permitted values}{an unquoted expression which evaluates to a character
(in \code{dataset})}
\item{Default value}{none}
}}

\item{values_yn}{Should \code{"Y"} and \code{"N"} be used for \code{CRITyFL}?

If set to \code{TRUE}, the \code{CRITyFL} variable is set to \code{"Y"} if the condition
(\code{condition}) evaluates to \code{TRUE}, it is set to \code{"N"} if the condition
evaluate to \code{FALSE}, and to \code{NA} if it evaluates to \code{NA}.

Otherwise, the \code{CRITyFL} variable is set to \code{"Y"} if the condition
(\code{condition}) evaluates to \code{TRUE}, and to \code{NA} otherwise.

\describe{
\item{Permitted values}{\code{TRUE}, \code{FALSE}}
\item{Default value}{\code{FALSE}}
}}

\item{create_numeric_flag}{Create a numeric flag?

If set to \code{TRUE}, the \code{CRITyFN} variable is created. It is set to \code{1} if
\code{CRITyFL == "Y"}, it set to \code{0} if \code{CRITyFL == "N"}, and to \code{NA} otherwise.

\describe{
\item{Permitted values}{\code{TRUE}, \code{FALSE}}
\item{Default value}{\code{FALSE}}
}}
}
\value{
The input dataset with the variables \code{CRITy}, \code{CRITyFL}, and
optionally \code{CRITyFN} added.
}
\description{
The function derives ADaM compliant criterion flags, e.g., to facilitate
subgroup analyses.

If a criterion flag can't be derived with this function, the derivation is
not ADaM compliant. It helps to ensure that:
\itemize{
\item the condition of the criterion depends only on variables of the same row,
\item the \code{CRITyFL} is populated with valid values, i.e, either \code{"Y"} and \code{NA} or
\code{"Y"}, \code{"N"}, and \code{NA},
\item the \code{CRITy} variable is populated correctly, i.e.,
\itemize{
\item set to a constant value within a parameter if \code{CRITyFL} is populated with
\code{"Y"}, \code{"N"}, and \code{NA} and
\item set to a constant value within a parameter if the criterion condition is
fulfilled and to \code{NA} otherwise if \code{CRITyFL} is populated with \code{"Y"},  and
\code{NA}
}
}
}
\seealso{
BDS-Findings Functions that returns variable appended to dataset:
\code{\link{derive_basetype_records}()},
\code{\link{derive_var_analysis_ratio}()},
\code{\link{derive_var_anrind}()},
\code{\link{derive_var_atoxgr}()},
\code{\link{derive_var_atoxgr_dir}()},
\code{\link{derive_var_base}()},
\code{\link{derive_var_chg}()},
\code{\link{derive_var_nfrlt}()},
\code{\link{derive_var_ontrtfl}()},
\code{\link{derive_var_pchg}()},
\code{\link{derive_var_shift}()}
}
\concept{der_bds_findings}
\keyword{der_bds_findings}
\section{Examples}{
\subsection{Data setup}{

The following examples use the BDS dataset below as a basis.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(tibble, warn.conflicts = FALSE)

adbds <- tribble(
  ~PARAMCD, ~AVAL,
  "AST",    42,
  "AST",    52,
  "AST",    NA_real_,
  "ALT",    33,
  "ALT",    51
)}\if{html}{\out{</div>}}}
\subsection{Creating a simple criterion flag with values \code{"Y"} and \code{NA}
(\code{condition}, \code{description})}{

The following call is a simple application of \code{derive_vars_crit_flag()}
to derive a criterion flag/variable pair in a BDS dataset.
\itemize{
\item The new variables are named \code{CRIT1}/\code{CRIT1FL} because the argument
\code{crit_nr} has not been passed.
\item Since the argument \code{values_yn} has also not been passed and thus is
set to its default of \code{FALSE}, \code{CRIT1FL} is set to \code{Y} only if
\code{condition} evaluates to \code{TRUE}. For example, in both the
first and third records, where \code{condition} is respectively \code{FALSE}
and \code{NA}, we set \code{CRIT1FL = NA_character_}. The fourth record also
exhibits this behavior. Also, as per CDISC standards, in this case
\code{CRIT1} is populated only for records where \code{condition} evaluates
to \code{TRUE}.
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{derive_vars_crit_flag(
  adbds,
  condition = AVAL > 50,
  description = "Absolute value > 50"
)
#> # A tibble: 5 × 4
#>   PARAMCD  AVAL CRIT1FL CRIT1              
#>   <chr>   <dbl> <chr>   <chr>              
#> 1 AST        42 <NA>    <NA>               
#> 2 AST        52 Y       Absolute value > 50
#> 3 AST        NA <NA>    <NA>               
#> 4 ALT        33 <NA>    <NA>               
#> 5 ALT        51 Y       Absolute value > 50}\if{html}{\out{</div>}}

The \code{description} argument also accepts expressions which depend
on other variables in the input dataset. This can be useful to
dynamically populate \code{CRITx}, for instance in the case below where
we improve the \code{CRIT1} text because the same flag/variable pair is
actually being used for multiple parameters.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{derive_vars_crit_flag(
  adbds,
  condition = AVAL > 50,
  description = paste(PARAMCD, "> 50"),
)
#> # A tibble: 5 × 4
#>   PARAMCD  AVAL CRIT1FL CRIT1   
#>   <chr>   <dbl> <chr>   <chr>   
#> 1 AST        42 <NA>    <NA>    
#> 2 AST        52 Y       AST > 50
#> 3 AST        NA <NA>    <NA>    
#> 4 ALT        33 <NA>    <NA>    
#> 5 ALT        51 Y       ALT > 50}\if{html}{\out{</div>}}}
\subsection{Creating a criterion flag with values \code{"Y"}, \code{"N"} and \code{NA}
(\code{values_yn})}{

The next call builds on the previous example by using
\code{value_yn = TRUE} to distinguish between the cases
where \code{condition} is \code{FALSE} and those where it is
not evaluable at all.
\itemize{
\item As compared to the previous example, for the first record \code{condition}
evaluates to \code{FALSE} and so we set \code{CRIT1FL = "N"}, whereas for the
third record, \code{condition} evaluates to \code{NA} because \code{AVAL} is
missing and so we set \code{CRIT1FL} to \code{NA}.
\item Note also that because we are using the values \code{"Y"}, \code{"N"} and \code{NA}
for the flag, as per CDISC standards \code{CRIT1} is now
populated for all records rather than just for the \code{"Y"} records.
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{derive_vars_crit_flag(
  adbds,
  condition = AVAL > 50,
  description = paste(PARAMCD, "> 50"),
  values_yn = TRUE
)
#> # A tibble: 5 × 4
#>   PARAMCD  AVAL CRIT1FL CRIT1   
#>   <chr>   <dbl> <chr>   <chr>   
#> 1 AST        42 N       AST > 50
#> 2 AST        52 Y       AST > 50
#> 3 AST        NA <NA>    AST > 50
#> 4 ALT        33 N       ALT > 50
#> 5 ALT        51 Y       ALT > 50}\if{html}{\out{</div>}}

If the user wishes to set the criterion flag to \code{"N"} whenever
the condition is not fulfilled, \code{condition} can be updated using
an \code{if_else} call, where the third argument determines the behavior
when the condition is not evaluable.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{derive_vars_crit_flag(
  adbds,
  condition = if_else(AVAL > 50, TRUE, FALSE, FALSE),
  description = paste(PARAMCD, "> 50"),
  values_yn = TRUE
)
#> # A tibble: 5 × 4
#>   PARAMCD  AVAL CRIT1FL CRIT1   
#>   <chr>   <dbl> <chr>   <chr>   
#> 1 AST        42 N       AST > 50
#> 2 AST        52 Y       AST > 50
#> 3 AST        NA N       AST > 50
#> 4 ALT        33 N       ALT > 50
#> 5 ALT        51 Y       ALT > 50}\if{html}{\out{</div>}}}
\subsection{Specifying the criterion variable/flag number and creating
a numeric flag (\code{crit_nr}, \code{create_numeric_flag}).}{

The user can manually specify the criterion variable/flag number
to use to name \code{CRITy}/\code{CRITyFL} by passing the \code{crit_nr} argument. This
may be necessary if, for instance, other criterion flags already exist
in the input dataset.

The user can also choose to create an additional, equivalent numeric
flag \code{CRITyFN} by setting \code{create_numeric_flag} to \code{TRUE}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{derive_vars_crit_flag(
  adbds,
  condition = AVAL > 50,
  description = paste(PARAMCD, "> 50"),
  values_yn = TRUE,
  crit_nr = 2,
  create_numeric_flag = TRUE
)
#> # A tibble: 5 × 5
#>   PARAMCD  AVAL CRIT2FL CRIT2    CRIT2FN
#>   <chr>   <dbl> <chr>   <chr>      <int>
#> 1 AST        42 N       AST > 50       0
#> 2 AST        52 Y       AST > 50       1
#> 3 AST        NA <NA>    AST > 50      NA
#> 4 ALT        33 N       ALT > 50       0
#> 5 ALT        51 Y       ALT > 50       1}\if{html}{\out{</div>}}}}

