% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_filters.R
\name{apply_filters}
\alias{apply_filters}
\title{Apply Filters to a Dataset}
\usage{
apply_filters(data, filters)
}
\arguments{
\item{data}{A data frame containing the raw data to be filtered.}

\item{filters}{A list of filters, where each filter is a list containing
the column, condition, and value.}
}
\value{
A data frame containing the filtered data.
}
\description{
This function applies a set of filters to a dataset. Each filter specifies a column,
condition, and value to filter the dataset.
}
\details{
The function iterates over the list of filters and applies each filter to the dataset.
The supported conditions are \code{==}, \code{>}, \code{<}, \code{>=}, \code{<=} and \code{!=}.
}
\examples{
# Example usage:
data <- mtcars
filters <- list(
  list(column = "mpg", condition = ">", value = "20"),
  list(column = "cyl", condition = "==", value = "6")
)
filtered_data <- apply_filters(data, filters)

}
