% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sex_interaction_analysis_bulk.R
\name{sex_interaction_analysis_bulk}
\alias{sex_interaction_analysis_bulk}
\title{Perform Sex-Phenotype Interaction Analysis for Bulk Data (Interaction Term)}
\usage{
sex_interaction_analysis_bulk(
  x,
  phenotype,
  gender,
  phenotype_labels = c("WT", "TG"),
  sex_labels = c("F", "M")
)
}
\arguments{
\item{x}{A numeric matrix of expression data (features x samples).}

\item{phenotype}{A character or factor vector indicating the condition for each sample.}

\item{gender}{A character or factor vector indicating the sex for each sample.}

\item{phenotype_labels}{Character vector. Labels for phenotype groups (default: c("WT", "TG")).}

\item{sex_labels}{Character vector. Labels for sexes (default: c("F", "M")).}
}
\value{
A data frame with differential expression statistics for the
        interaction term, including logFC, t-statistic, P-value, and
        adjusted P-value.
}
\description{
This function performs a formal interaction analysis on bulk expression data
to identify genes whose expression is significantly modulated by the interaction
between sex and a given phenotype/condition. It uses a linear model with a
multiplicative interaction term (`phenotype * sex`).
}
\details{
This function constructs a design matrix that includes a formal interaction term
         between the phenotype and sex (e.g., `~ phenotype * sex`). It then uses `limma`
         to test for genes where the effect of the phenotype differs significantly
         between sexes. This is a statistically rigorous approach to identify
         sex-modulated genes.
}
