% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storage.R
\name{InMemoryStorage}
\alias{InMemoryStorage}
\title{In-Memory Storage}
\description{
Fast in-memory storage backend
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{Storage data}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-InMemoryStorage-new}{\code{InMemoryStorage$new()}}
\item \href{#method-InMemoryStorage-set}{\code{InMemoryStorage$set()}}
\item \href{#method-InMemoryStorage-get}{\code{InMemoryStorage$get()}}
\item \href{#method-InMemoryStorage-delete}{\code{InMemoryStorage$delete()}}
\item \href{#method-InMemoryStorage-exists}{\code{InMemoryStorage$exists()}}
\item \href{#method-InMemoryStorage-keys}{\code{InMemoryStorage$keys()}}
\item \href{#method-InMemoryStorage-clear}{\code{InMemoryStorage$clear()}}
\item \href{#method-InMemoryStorage-count}{\code{InMemoryStorage$count()}}
\item \href{#method-InMemoryStorage-clone}{\code{InMemoryStorage$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InMemoryStorage-new"></a>}}
\if{latex}{\out{\hypertarget{method-InMemoryStorage-new}{}}}
\subsection{Method \code{new()}}{
Create new in-memory storage
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InMemoryStorage$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InMemoryStorage-set"></a>}}
\if{latex}{\out{\hypertarget{method-InMemoryStorage-set}{}}}
\subsection{Method \code{set()}}{
Store a value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InMemoryStorage$set(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Storage key}

\item{\code{value}}{Value to store}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InMemoryStorage-get"></a>}}
\if{latex}{\out{\hypertarget{method-InMemoryStorage-get}{}}}
\subsection{Method \code{get()}}{
Retrieve a value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InMemoryStorage$get(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Storage key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Stored value or NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InMemoryStorage-delete"></a>}}
\if{latex}{\out{\hypertarget{method-InMemoryStorage-delete}{}}}
\subsection{Method \code{delete()}}{
Delete a value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InMemoryStorage$delete(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Storage key}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InMemoryStorage-exists"></a>}}
\if{latex}{\out{\hypertarget{method-InMemoryStorage-exists}{}}}
\subsection{Method \code{exists()}}{
Check if key exists
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InMemoryStorage$exists(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Storage key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InMemoryStorage-keys"></a>}}
\if{latex}{\out{\hypertarget{method-InMemoryStorage-keys}{}}}
\subsection{Method \code{keys()}}{
List all keys
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InMemoryStorage$keys()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character vector of keys
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InMemoryStorage-clear"></a>}}
\if{latex}{\out{\hypertarget{method-InMemoryStorage-clear}{}}}
\subsection{Method \code{clear()}}{
Clear all data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InMemoryStorage$clear()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InMemoryStorage-count"></a>}}
\if{latex}{\out{\hypertarget{method-InMemoryStorage-count}{}}}
\subsection{Method \code{count()}}{
Get count of stored items
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InMemoryStorage$count()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer count
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InMemoryStorage-clone"></a>}}
\if{latex}{\out{\hypertarget{method-InMemoryStorage-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InMemoryStorage$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
