% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphrag.R
\name{Entity}
\alias{Entity}
\title{Entity}
\description{
An extracted entity
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{Unique identifier}

\item{\code{name}}{Entity name}

\item{\code{type}}{Entity type}

\item{\code{description}}{Description}

\item{\code{source_chunks}}{Source chunk IDs}

\item{\code{embedding}}{Vector embedding}

\item{\code{metadata}}{Additional metadata}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Entity-new}{\code{Entity$new()}}
\item \href{#method-Entity-to_list}{\code{Entity$to_list()}}
\item \href{#method-Entity-clone}{\code{Entity$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Entity-new"></a>}}
\if{latex}{\out{\hypertarget{method-Entity-new}{}}}
\subsection{Method \code{new()}}{
Create a new Entity
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Entity$new(
  id = NULL,
  name,
  type,
  description = NULL,
  source_chunks = NULL,
  embedding = NULL,
  metadata = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Unique ID}

\item{\code{name}}{Name}

\item{\code{type}}{Type}

\item{\code{description}}{Description}

\item{\code{source_chunks}}{Sources}

\item{\code{embedding}}{Vector}

\item{\code{metadata}}{Metadata}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Entity-to_list"></a>}}
\if{latex}{\out{\hypertarget{method-Entity-to_list}{}}}
\subsection{Method \code{to_list()}}{
Convert to list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Entity$to_list()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Entity-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Entity-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Entity$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
