% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{CacheConfig}
\alias{CacheConfig}
\title{Cache Configuration}
\description{
Configuration for cache layer
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{backend}}{Cache backend type}

\item{\code{memory_max_size}}{Max items in memory}

\item{\code{memory_ttl_seconds}}{Default TTL in seconds}

\item{\code{file_cache_dir}}{Directory for file cache}

\item{\code{file_ttl_seconds}}{File cache TTL}

\item{\code{prefix}}{Cache key prefix}

\item{\code{compression}}{Use compression}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CacheConfig-new}{\code{CacheConfig$new()}}
\item \href{#method-CacheConfig-clone}{\code{CacheConfig$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CacheConfig-new"></a>}}
\if{latex}{\out{\hypertarget{method-CacheConfig-new}{}}}
\subsection{Method \code{new()}}{
Create a new CacheConfig
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CacheConfig$new(
  backend = "memory",
  memory_max_size = 10000,
  memory_ttl_seconds = 3600,
  file_cache_dir = NULL,
  file_ttl_seconds = 86400,
  prefix = "vectrix:",
  compression = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{backend}}{Backend type}

\item{\code{memory_max_size}}{Max memory items}

\item{\code{memory_ttl_seconds}}{Memory TTL}

\item{\code{file_cache_dir}}{File cache directory}

\item{\code{file_ttl_seconds}}{File TTL}

\item{\code{prefix}}{Key prefix}

\item{\code{compression}}{Use compression}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CacheConfig-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CacheConfig-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CacheConfig$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
