% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_matrix.R
\name{plot_matrix}
\alias{plot_matrix}
\title{Plot Matrix with Entries Represented 
  by Balloons of Varying Sizes and Colors}
\usage{
plot_matrix(
  x,
  title = "Balloon plot",
  shape.color = c("tomato"),
  s.min = 1,
  s.max = 30,
  x.axis = NULL,
  y.axis = NULL,
  x.lab = "",
  y.lab = "",
  bg.color = "white",
  grid.color = "black",
  grid.width = 0.1,
  size.by = c("column", "row", "global", "none"),
  color.by = c("column", "row", "global", "none"),
  number.size = 6,
  shape.by = c("column", "row", ""),
  shapes = c(21, 22, 23, 24)
)
}
\arguments{
\item{x}{a numeric matrix or table to be plotted.}

\item{title}{a character string for the main title of the plot.
Defaults to \code{"Balloon plot"}.}

\item{shape.color}{a character string specifying the
color for entries (e.g., \code{"tomato"}, \code{"blue"}).}

\item{s.min}{a numeric value specifying the minimum size
of the shapes. Defaults to 5.}

\item{s.max}{a numeric value specifying the maximum size
of the shapes. Defaults to 30.}

\item{x.axis}{a character vector for custom x-axis labels.
If \code{NULL}, column names of \code{x} are used. 
Set to \code{""} to hide labels.}

\item{y.axis}{a character vector for custom y-axis labels.
If \code{NULL}, row names of \code{x} are used. 
Set to \code{""} to hide labels.}

\item{x.lab}{a character string for the x-axis title. 
Defaults to \code{""}.}

\item{y.lab}{a character string for the y-axis title.
Defaults to \code{""}.}

\item{bg.color}{a character string for the background
color of the tiles. Defaults to \code{"white"}.}

\item{grid.color}{a character string specifying color of
grid lines (\code{NA} to remove).}

\item{grid.width}{a numeric value to specify the width
of grid lines.}

\item{size.by}{a character string to specify how to
scale the size of balloon: \code{"column"} (Default), 
\code{"row"}, \code{"global"}, or \code{"none"}.}

\item{color.by}{a character string to specify how to
scale the color of balloon: \code{"global"} (Default), 
\code{"row"}, \code{"column"}, or \code{"none"}.}

\item{number.size}{a numeric value specifying the font
size for text.}

\item{shape.by}{a character string to specify how to 
choose the shape of balloon: \code{"column"} (Default), 
\code{"row"}, or \code{""} (none).}

\item{shapes}{a character vector to specify shape codes.}
}
\value{
A ggplot object.
}
\description{
Creates a "balloon plot" to visualize 
  numeric data in a matrix or contingency table.
}
\details{
Each entry in the matrix is represented by 
  a shape, with size and color corresponding to the
  magnitude of value in the entry. It offers an
  alternative to heatmap for displaying count data.
}
\examples{
library(ggplot2)
mat <- matrix(c(10, 20, 30, 50, 80, 60, 40, 30), nrow = 2)
rownames(mat) <- c("Row1", "Row2")
colnames(mat) <- c("C1", "C2", "C3", "C4")

# Color by Row (Row 1 = red, Row 2 = blue)
plot_matrix(mat, color.by = "row", shape.color = c("tomato", "steelblue"))

# Color by Column (Rainbow colors)
plot_matrix(mat, color.by = "column", shape.color = c("red", "green", "blue", "orange"))
}
\keyword{internal}
