% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_Boxplot.R
\name{Plot.Boxplot}
\alias{Plot.Boxplot}
\title{Cree un diagrama de caja/boxplot dinámico y flexible con dos diferentes paquetes}
\usage{
Plot.Boxplot(
  datos,
  variable,
  grupo1,
  grupo2,
  vertical = TRUE,
  outliers = TRUE,
  jitter = FALSE,
  violin = FALSE,
  numericalVars,
  ylim,
  colores,
  sizeOutlier = 0,
  colOutlier = "#08306B",
  titulo = "",
  labelX = "Periodo",
  labelY = "",
  textBox = "",
  libreria = c("highcharter", "plotly"),
  estilo = NULL,
  estatico = FALSE
)
}
\arguments{
\item{datos}{Un data frame, no un vector numérico.}

\item{variable}{Una variable numérica dentro del data frame ingresado en \code{datos}.}

\item{grupo1}{Una variable categórica dentro del data frame ingresado en \code{datos}.}

\item{grupo2}{Otra variable categórica dentro del data frame ingresado en \code{datos}
por si se desea segregar por otra clase el grupo principal.}

\item{vertical}{Si es \code{TRUE} (\emph{valor predeterminado}) indicará que la orientación
del gráfico será vertical.}

\item{outliers}{Si es \code{TRUE} (\emph{valor predeterminado}) se mostrarán los puntos
correspondientes a los datos atípicos, defínalo en \code{FALSE} si desea ocultar
dichos puntos.}

\item{jitter}{Si es \code{TRUE} se agregará las observaciones de cada grupo con un
poco de ruido aleatorio encima de las cajas, útil para mostrar la distribución
subyacente de los datos. El valor por defecto es \code{FALSE}.}

\item{violin}{Si es \code{TRUE} se acompañará el boxplot con su diagrama de densidad,
logrando ser más informativo al mostrar la distribución completa de los datos.
Solo aplica para la librería \code{"plotly"}.}

\item{numericalVars}{Una lista (\emph{ya sea creada con la sintaxis \code{base} o \code{tidy}})
con las variables numéricas dentro del data frame ingresado en \code{datos} con
las que se desea crear un botón dinámico para desplazarse entre ellas fijando
el grupo ingresado en \code{grupo1}.}

\item{ylim}{Vector numérico que especifica el límite inferior y superior,
respectivamente, del eje \code{Y}. Si no se introduce algún valor se mostrará todo
el rango disponible para dicho eje.}

\item{colores}{Cadena de caracteres indicando los colores con los cuales se
deben colorear cada una de las trazas correspondiente a cada nivel del argumento
\code{grupo1}. Si no se introduce algún vector se usará la paleta \code{rainbow} por defecto.}

\item{sizeOutlier}{Valor numérico que indica el tamaño de los puntos considerados
como atípicos, por defecto se tiene un valor específico al que se le sumará
el ingresado acá.}

\item{colOutlier}{Cadena de caracteres indicando el color de los puntos
considerados como atípicos, por defecto se pintarán de un azul rey.}

\item{titulo}{Cadena de caracteres indicando el título principal del plot.}

\item{labelX}{Cadena de caracteres indicando la etiqueta del eje \code{X}. Por
defecto se emplea el rótulo "Periodo".}

\item{labelY}{Cadena de caracteres indicando la etiqueta del eje \code{Y}.}

\item{textBox}{Cadena de caracteres indicando el nombre de la serie numérica
con la que se construye las cajas, necesario únicamente si se especifica
solamente el \code{grupo1}, para el caso en que se tenga dos grupos no tendrá
ningún efecto en el plot.}

\item{libreria}{Cadena de caracteres que indica el paquete con el cual se realizará
el plot. Los valores permitidos son \code{"highcharter"} (\emph{valor predeterminado})
y \code{"plotly"}. Los valores se emparejarán parcialmente.}

\item{estilo}{Lista compuesta por varios parámetros, los cuales van a ser usados
de acuerdo con la librería especificada para graficar el boxplot y cuyo
objetivo es personalizar pequeños detalles de éste.
\itemize{
\item \code{LegendTitle}, \code{hc.Tema} y \code{hc.Credits}: Igual uso que en \code{\link[=Plot.Series]{Plot.Series()}}
\item \code{ply.Interaction}, \code{ply.LegendPosition} y \code{ply.Credits}: Igual uso que en
\code{\link[=Plot.Series]{Plot.Series()}}
\item \code{gg.Tema}, \code{gg.Legend} y \code{gg.Texto}: Igual uso que en \code{\link[=Plot.Series]{Plot.Series()}}
\item \code{gg.VarWidth}: Si es \code{FALSE} (\emph{valor predeterminado}) se realizará
un diagrama de caja estándar. Si es \code{TRUE}, las cajas se dibujan con anchos
proporcionales a las raíces cuadradas del número de observaciones en los
grupos. Para más información, consulte la función \link[ggplot2:geom_boxplot]{geom_boxplot()}).
\item \code{gg.OutShape}: Modifica la forma de los outliers (\emph{datos atípicos}).
Los posibles valores son un número entero entre \eqn{[1, 23]}. Para más
información consulte la función \link[ggplot2:geom_boxplot]{geom_boxplot()}).
\item \code{gg.JitWidth}: Valor numérico que indica el tamaño del ancho en el que los
puntos pueden dispersarse en cada una de las cajas El valor por defecto es
\code{0.25}. Para más información, consulte la función \link[ggplot2:geom_jitter]{geom_jitter()}).
\item \code{gg.JitSize}: Valor numérico que indica el tamaño de los jittered points.
El valor por defecto es \code{0.4}. Para más información, consulte la función
\link[ggplot2:geom_jitter]{geom_jitter()}).
}}

\item{estatico}{Si es \code{FALSE} (\emph{valor predeterminado}) el gráfico a retornar
será dinámico (\emph{dependiendo de la librería seleccionada}), en caso contrario
se retornará un gráfico estático construido con \code{ggplot2}.}
}
\value{
Retorna el boxplot (\emph{objeto widget de HTML}) creado. La clase del objeto retornado
será un "htmlwidget" y dependiendo de la librería usada pertenecerá adicionalmente
a la clase "highchart" o "plotly".
}
\description{
Esta función proporciona excelentes herramientas y opciones para la visualización
de un diagrama de caja y bigotes (\emph{también conocido como boxplot}) dinámico
con el objetivo de representar gráficamente una serie numérica a través de sus
cuantiles. Dicho boxplot se puede representar usando dos diferentes librerías
que son \code{Highcharter} y \code{Plotly}, las cuales usan internamente \code{JavaScript}.
}
\details{
El argumento \code{numericalVars} funciona solamente con la librería \code{"plotly"},
pues la función de crear los botones dinámicos es procedente de dicha librería.
}
\section{Lista de argumentos de estilo}{


Sabemos que puede ser abrumador el número de argumentos dentro del parámetro
\code{estilo}, pero es necesario si queremos ofrecer al usuario la máxima
personalización dentro de cada función usando cualquier librería. Por tal
razón, a continuación, se detalla el listado completo de argumentos, usados
al especificar la librería y en qué función están presentes
(\emph{marcado con una × si lo posee}).\tabular{clcccccccc}{
   \strong{Librería} \tab \strong{estilo$} \tab \code{\link[=Plot.Series]{Plot.Series()}} \tab \code{\link[=Plot.Barras]{Plot.Barras()}} \tab \code{\link[=Plot.Apiladas]{Plot.Apiladas()}} \tab \code{\link[=Plot.Boxplot]{Plot.Boxplot()}} \tab \code{\link[=Plot.Radar]{Plot.Radar()}} \tab \code{\link[=Plot.Treemap]{Plot.Treemap()}} \tab \code{\link[=Plot.Torta]{Plot.Torta()}} \tab \code{\link[=Plot.Drilldown]{Plot.Drilldown()}} \cr
   — \tab \emph{gg.Tema} \tab × \tab × \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Texto} \tab × \tab × \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Legend} \tab × \tab  \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Linea} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Punto} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Bar} \tab  \tab × \tab × \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.VarWidth} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.OutShape} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.JitWidth} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.JitSize} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Range} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{ggplot2} \tab \emph{gg.plty} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.plwd} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.cglwd} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.cglcol} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.fontsize.title} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.fontsize.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.fontcolor.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.border.lwds} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.border.col} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.lowerbound.cex.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.force.print.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   — \tab \emph{gg.overlap.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   » \tab \emph{hc.Tema} \tab × \tab × \tab × \tab × \tab  \tab × \tab × \tab × \cr
   l \tab \emph{hc.Credits} \tab × \tab × \tab × \tab × \tab  \tab × \tab × \tab × \cr
   \strong{highcharter} \tab \emph{hc.BoxInfo} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{hc.Slider} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   » \tab \emph{hc.borderRadius} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   • \tab \emph{ply.Credits} \tab × \tab × \tab × \tab × \tab × \tab × \tab × \tab  \cr
   ° \tab \emph{ply.Legend} \tab  \tab × \tab  \tab  \tab  \tab  \tab × \tab  \cr
   ° \tab \emph{ply.LegendPosition} \tab × \tab  \tab × \tab × \tab × \tab  \tab  \tab  \cr
   \strong{plotly} \tab \emph{ply.Interaction} \tab × \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   ° \tab \emph{ply.Relleno} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   ° \tab \emph{ply.Opacidad} \tab  \tab  \tab  \tab  \tab × \tab × \tab  \tab  \cr
   • \tab \emph{ply.LegendTitle} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{dygraphs} \tab \emph{dyg.LegendWidth} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   » \tab \emph{dyg.Resaltar} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   — \tab \emph{e.Tema} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{e.Credits} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{echarts4r} \tab \emph{e.Forma} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{e.LegType} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   — \tab \emph{e.LegLoc} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
}
}

\examples{
\dontshow{if (require("pals")) withAutoprint(\{ # examplesIf}
Txt <- "EVOLUCI\u00d3N DEL PUNTAJE EN EL EXAMEN DE ADMISI\u00d3N"
Msj <- "Aspirantes a pregrado (<i>no se incluye los datos at\u00edpicos</i>)"
Plot.Boxplot(
  datos       = ejMiniAspirantesPre,
  variable    = PTOTAL,
  grupo1      = Serie,
  outliers    = FALSE,
  ylim        = c(0, 1000),
  colores     = pals::jet(30),
  sizeOutlier = 1,
  colOutlier  = "#FF3366",
  titulo      = Txt,
  labelY      = "Puntaje",
  textBox     = "Score",
  libreria    = "highcharter",
  estilo      = list(hc.Tema = 2, hc.Credits = Msj)
)
\dontshow{\}) # examplesIf}
# ---------------------------------------------------------------------------
Txt <- "EVOLUCI\u00d3N DEL PUNTAJE EN EL EXAMEN DE ADMISI\u00d3N"
Msj2 <- paste(
  "Aspirantes a pregrado",
  "(<i>cada periodo se encuentra segregado por el tipo de admisi\u00f3n</i>)"
)
Plot.Boxplot(
  datos    = ejMiniAspirantesPre,
  variable = PTOTAL,
  grupo1   = Serie,
  grupo2   = TIPO_INS,
  outliers = TRUE,
  ylim     = c(0, 1000),
  colores  = c("#00ABFF", "#F3224B", "#FCD116", "#29DF2C"),
  titulo   = Txt,
  labelY   = "Puntaje",
  libreria = "highcharter",
  estilo   = list(LegendTitle = "Programa:", hc.Tema = 6, hc.Credits = Msj2)
)
# ---------------------------------------------------------------------------
Plot.Boxplot(
  datos    = iris,
  variable = Sepal.Length,
  grupo1   = Species,
  violin   = TRUE,
  colores  = c("#FF1D58", "#FDB911", "#00E527"),
  titulo   = "BOXPLOT DE LA LONGITUD DEL S\u00c9PALO | IRIS DATASET",
  labelX   = "Especie",
  labelY   = "Longitud del S\u00e9palo",
  libreria = "plotly"
)
# ---------------------------------------------------------------------------
Plot.Boxplot(
  datos       = ejMiniAspirantesPre,
  variable    = PTOTAL,
  grupo1      = Serie,
  grupo2      = TIPO_INS,
  jitter      = TRUE,
  ylim        = c(0, 1000),
  colores     = c("#00ABFF", "#F3224B", "#FCD116", "#29DF2C"),
  sizeOutlier = 0,
  colOutlier  = "#D3D3D3",
  titulo      = Txt,
  labelY      = "Puntaje",
  libreria    = "plotly",
  estilo      = list(
    LegendTitle = "Programa:", ply.Interaction = "closest",
    ply.LegendPosition = list(x = 0.16, y = -0.25, orientation = "h"),
    ply.Credits = list(x = 0.4, y = 0.95, text = Msj2)
  )
) -> Advertencia
suppressWarnings(print(Advertencia))

\dontshow{if (require("dplyr")) withAutoprint(\{ # examplesIf}
# ---------------------------------------------------------------------------
# library(dplyr)
df <- ejSaberPro2020 |>
  select(SEDE_NOMBRE_ADM, PUNTAJE_GLOBAL, PUNT_RAZO_CUANT, PUNT_INGLES,
         PUNT_LECT_CRIT, PUNT_COMP_CIUD, PUNT_COMU_ESCR
         )
Numericas <- vars(PUNT_RAZO_CUANT, PUNT_INGLES, PUNT_LECT_CRIT, PUNT_COMP_CIUD, PUNT_COMU_ESCR)
# Numericas <- c("PUNT_RAZO_CUANT", "PUNT_INGLES", ... , "PUNT_COMU_ESCR")
misColores <- c(
  "#29ABE2", # AZUL CLARO  | Amazonia
  "#8CC63F", # VERDE       | Bogota
  "#CC241D", # ROJO        | Caribe
  "#0071BC", # AZUL VIVO   | Manizales
  "#F15A24", # NARANJA     | Medellin
  "#FBB03B", # AMARILLO    | Orinoquia
  "#93278F", # MORADO      | Palmira
  "#8A381A"  # GRIS        | Tumaco
)
Plot.Boxplot(
  datos         = df,
  variable      = PUNTAJE_GLOBAL,
  grupo1        = SEDE_NOMBRE_ADM,
  numericalVars = Numericas,
  colores       = misColores,
  libreria      = "plotly"
)
\dontshow{\}) # examplesIf}
\dontshow{if (require("pals")) withAutoprint(\{ # examplesIf}
# ---------------------------------------------------------------------------
# Ejemplo usando el caso estático (ggplot2)
# library(pals)
Plot.Boxplot(
  datos      = ejMiniAspirantesPre,
  variable   = PTOTAL,
  grupo1     = Serie,
  jitter     = TRUE,
  colores    = pals::turbo(30),
  colOutlier = "#CBB8FF",
  titulo     = gsub("L E", "L\nE", Txt),
  labelY     = "Puntaje",
  textBox    = "Score",
  estatico   = TRUE,
  estilo     = list(
    gg.Tema = 11, gg.Legend = list(legend.position = "none"),
    gg.Texto = list(
      subtitle = gsub("<|/|i>", "", Msj ),
      caption  = "Información Disponible desde 2008-1", tag = "\u00ae"
    ),
    gg.VarWidth = TRUE, gg.JitWidth = 0.08, gg.JitSize = 0.05
  )
)
\dontshow{\}) # examplesIf}
# ---------------------------------------------------------------------------
Plot.Boxplot(
  datos       = ejMiniAspirantesPre,
  variable    = PTOTAL,
  grupo1      = Serie,
  grupo2      = TIPO_INS,
  outliers    = TRUE,
  colores     = c("#00ABFF", "#F3224B", "#FCD116", "#29DF2C"),
  sizeOutlier = 2,
  colOutlier  = "#F5E8E8",
  titulo      = gsub("L E", "L\nE", Txt),
  labelY      = "Puntaje",
  textBox     = "Score",
  estatico    = TRUE,
  estilo      = list(
    LegendTitle = "NIVEL ACAD\u00c9MICO:", gg.Tema = 9, gg.OutShape = 21,
    gg.Legend = list(legend.position = "bottom", legend.direction = "horizontal"),
    gg.Texto = list(
      subtitle = gsub("<|/|i>", "", Msj2),
      caption  = "Información Disponible desde 2008-1", tag = "\u00ae"
    )
  )
)

}
