% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Milestones.R
\docType{class}
\name{Milestones}
\alias{Milestones}
\title{Class of Milestones}
\description{
Create a class of milestone. A milestone means the time point to take an action,
e.g., carrying out (futility, interim, final) analysis for
adding/removing arms, or stopping a trial early.
It can also be any more general time point where trial
data is used in decision making or adaptation. For example, one can define a
milestone for changing randomization scheme, sample size re-assessment, trial
duration extension etc.

Public methods in this R6 class are used in developing
this package. Thus, we have to export the whole R6 class which exposures all
public methods. However, none of the public methods on this page is
useful to end users. Instead, refer to the
\href{https://zhangh12.github.io/TrialSimulator/articles/conditionSystem.html}{vignette}
to learn how to define milestones when performing simulation using
\code{TrialSimulator}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Milestones-new}{\code{Milestones$new()}}
\item \href{#method-Milestones-get_name}{\code{Milestones$get_name()}}
\item \href{#method-Milestones-get_type}{\code{Milestones$get_type()}}
\item \href{#method-Milestones-get_trigger_condition}{\code{Milestones$get_trigger_condition()}}
\item \href{#method-Milestones-get_action}{\code{Milestones$get_action()}}
\item \href{#method-Milestones-set_dry_run}{\code{Milestones$set_dry_run()}}
\item \href{#method-Milestones-execute_action}{\code{Milestones$execute_action()}}
\item \href{#method-Milestones-get_trigger_status}{\code{Milestones$get_trigger_status()}}
\item \href{#method-Milestones-reset}{\code{Milestones$reset()}}
\item \href{#method-Milestones-trigger_milestone}{\code{Milestones$trigger_milestone()}}
\item \href{#method-Milestones-mute}{\code{Milestones$mute()}}
\item \href{#method-Milestones-clone}{\code{Milestones$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Milestones-new"></a>}}
\if{latex}{\out{\hypertarget{method-Milestones-new}{}}}
\subsection{Method \code{new()}}{
initialize milestone
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Milestones$new(name, type = name, trigger_condition, action = doNothing, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{character. Name of milestone.}

\item{\code{type}}{character vector. Milestone type(s) (futility, interim, final),
a milestone can be of multiple types. This is for information purpose so
can be any string.}

\item{\code{trigger_condition}}{function to check if this milestone should
trigger. See vignette \code{Condition System for Triggering Milestones in a Trial}.}

\item{\code{action}}{function to execute when the milestone triggers.}

\item{\code{...}}{(optional) arguments of \code{action}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Milestones-get_name"></a>}}
\if{latex}{\out{\hypertarget{method-Milestones-get_name}{}}}
\subsection{Method \code{get_name()}}{
return name of milestone
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Milestones$get_name()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Milestones-get_type"></a>}}
\if{latex}{\out{\hypertarget{method-Milestones-get_type}{}}}
\subsection{Method \code{get_type()}}{
return type(s) of milestone
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Milestones$get_type()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Milestones-get_trigger_condition"></a>}}
\if{latex}{\out{\hypertarget{method-Milestones-get_trigger_condition}{}}}
\subsection{Method \code{get_trigger_condition()}}{
return trigger_condition function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Milestones$get_trigger_condition()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Milestones-get_action"></a>}}
\if{latex}{\out{\hypertarget{method-Milestones-get_action}{}}}
\subsection{Method \code{get_action()}}{
return action function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Milestones$get_action()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Milestones-set_dry_run"></a>}}
\if{latex}{\out{\hypertarget{method-Milestones-set_dry_run}{}}}
\subsection{Method \code{set_dry_run()}}{
set if dry run should be carried out for the milestone. For more details,
refer to \code{Controller::run}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Milestones$set_dry_run(dry_run)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dry_run}}{logical.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Milestones-execute_action"></a>}}
\if{latex}{\out{\hypertarget{method-Milestones-execute_action}{}}}
\subsection{Method \code{execute_action()}}{
execute action function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Milestones$execute_action(trial)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{trial}}{a \code{Trial} object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Milestones-get_trigger_status"></a>}}
\if{latex}{\out{\hypertarget{method-Milestones-get_trigger_status}{}}}
\subsection{Method \code{get_trigger_status()}}{
return trigger status
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Milestones$get_trigger_status()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Milestones-reset"></a>}}
\if{latex}{\out{\hypertarget{method-Milestones-reset}{}}}
\subsection{Method \code{reset()}}{
reset an milestone so that it can be triggered again. Usually, this is called
before the controller of a trial can run additional replicates
of simulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Milestones$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Milestones-trigger_milestone"></a>}}
\if{latex}{\out{\hypertarget{method-Milestones-trigger_milestone}{}}}
\subsection{Method \code{trigger_milestone()}}{
trigger an milestone (always TRUE) and execute action accordingly. It calls
Trial$get_data_lock_time() to lock data based on conditions implemented
in Milestones$trigger_condition. If time that meets the condition cannot be
found, Trial$get_data_lock_time() will throw an error and stop the
program. This means that user needs to adjust their trigger_condition
(e.g., target number of events (target_n_events) is impossible to
reach).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Milestones$trigger_milestone(trial)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{trial}}{a \code{Trial} object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Milestones-mute"></a>}}
\if{latex}{\out{\hypertarget{method-Milestones-mute}{}}}
\subsection{Method \code{mute()}}{
mute all messages (not including warnings)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Milestones$mute(silent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{silent}}{logical.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Milestones-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Milestones-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Milestones$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
