% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snp_king.R
\name{snp_king}
\alias{snp_king}
\title{Compute the KING-robust Matrix for a bigSNP object}
\usage{
snp_king(
  X,
  ind.row = bigstatsr::rows_along(X),
  ind.col = bigstatsr::cols_along(X),
  block.size = bigstatsr::block_size(nrow(X)) * 4
)
}
\arguments{
\item{X}{a \link[bigstatsr:FBM.code256-class]{bigstatsr::FBM.code256} matrix (as found in the \code{genotypes}
slot of a \link[bigsnpr:bigSNP-class]{bigsnpr::bigSNP} object).}

\item{ind.row}{An optional vector of the row indices that are used.
If not specified, all rows are used. Don't use negative indices.}

\item{ind.col}{An optional vector of the column indices that are used. If not
specified, all columns are used. Don't use negative indices.}

\item{block.size}{maximum number of columns read at once.}
}
\value{
a square symmetrical matrix of relationship coefficients between
individuals
}
\description{
This function computes the KING-robust estimator of kinship.
}
\examples{
example_gt <- load_example_gt("gen_tbl")

X <- attr(example_gt$genotypes, "bigsnp")
snp_king(X$genotypes)

# Compute for individuals 1 to 5
snp_king(X$genotypes, ind.row = 1:5, ind.col = 1:5)

# Adjust block size
snp_king(X$genotypes, block.size = 2)

}
