% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confband.R
\name{plot.rt_confidence_band}
\alias{plot.rt_confidence_band}
\title{Plot estimated confidence bands for an estimate of Rt}
\usage{
\method{plot}{rt_confidence_band}(x, colour = "#3A448F", ...)
}
\arguments{
\item{x}{An object of class \code{rt_confidence_band} as produced by \code{confband()}.}

\item{colour}{The colour of the desired plot}

\item{...}{Not used.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Produces a figure showing a single estimated Rt value along with approximate
confidence bands. The result is a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}. Additional user
modifications can be added as desired.
}
\examples{

y <- c(1, rpois(100, dnorm(1:100, 50, 15) * 500 + 1))
out <- estimate_rt(y, nsol = 10)
cb <- confband(out, out$lambda[2], level = c(0.95, 0.8, 0.5))
plot(cb)
cb_y <- confband(out, out$lambda[2], level = c(0.95, 0.8, 0.5), type = "Yt")
plot(cb_y)
}
