% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flexCItwd.R
\name{flexCItwd}
\alias{flexCItwd}
\title{Wrapper for gaussCItwd, disCItwd and mixCItwd}
\usage{
flexCItwd(x, y, S = NULL, data)
}
\arguments{
\item{x, y, S}{(Integer) position of variable X, Y and set of variables S,
respectively, in each correlation matrix in \code{suffStat}. It is tested
whether X and Y are conditionally independent given the subset S of the
remaining variables.}

\item{data}{A data frame}
}
\value{
A p-value
}
\description{
A plug-in conditional independence test for \code{pcalg::\link[pcalg]{skeleton}}, \code{pcalg::\link[pcalg]{pc}} or
\code{pcalg::\link[pcalg]{fci}} when the data contain missing values. Observations
where at least one of the variables involved in the test is missing are
deleted prior to performing the test (test-wise deletion). The function \code{flexCItwd} detects whether
variables are continuous, discrete or mixed, and automatically switches between \code{\link{gaussCItwd}} (continuous only),
\code{link{disCItwd}} (discrete only) and \code{\link{mixCItwd}} (mixed).
}
\examples{
## load data (numeric and factor variables)
dat <- toenail2[1:400, ]

## delete some observations
set.seed(123)
dat[sample(400, 20), 2] <- NA
dat[sample(400, 30), 4] <- NA

## obtain correct input 'suffStat' for 'flexMItest'
suff <- getSuff(imp, test="flexCItwd")

## analyse data
# continuous variables only
flexCItwd(4, 5, NULL, dat)

# discrete variables only
flexCItwd(2, 3, NULL, dat)

# mixed variables
flexCItwd(2, 3, 4, dat)

}
