% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tetracorr.R
\name{tetracorr}
\alias{tetracorr}
\title{Calculate Tetrachoric Correlations}
\usage{
tetracorr(data, varlist)
}
\arguments{
\item{data}{data frame with "markname" and study names as column names.}

\item{varlist}{character vector of study names to include in the meta-analysis.}
}
\value{
list containing a data frame with tetrachoric correlation coefficients,
and the sum of the tetrachoric correlations if the input variable was in
p-value form.
}
\description{
This function calculates the tetrachoric correlations between pairs of variables
in a given data frame. It returns a list containing a data frame with the tetrachoric
correlation coefficients, and the sum of the tetrachoric correlations if the
input variable was in p-value form.
}
\examples{
  data(snp_example)
  head(snp_example)
  varlist <- c("trt1","trt2","trt3")
  tetracorr(snp_example, varlist)
}
\seealso{
\code{\link{polychor}}
}
\author{
Woo Jung
}
