% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_data.R
\docType{data}
\name{OptionsBigboss}
\alias{OptionsBigboss}
\title{Bigboss pre-defined parameter values for single models}
\format{
A \code{\link{BIOMOD.models.options}} object with some changed values :

\describe{
   \item{\code{ANN.nnet.nnet}}{
     \itemize{
       \item \code{size = 5}
       \item \code{decay = 0.1}
       \item \code{trace = FALSE}
       \item \code{rang = 0.1}
       \item \code{maxit = 200}
     }
   }
   \item{\code{CTA.rpart.rpart}}{
     \itemize{
       \item \code{control = list(xval = 5, minbucket = 5, minsplit = 5, cp = 0.001, maxdepth = 10)}
       \item \code{cost = NULL}
     }
   }
   \item{\code{DNN.cito.dnn}}{
     \itemize{
       \item \code{batchsize = 100L}
       \item \code{epochs = 150L}
       \item \code{hidden = c(100L, 100L) }
       \item \code{lr = 0.05}
       \item \code{optimizer = "adam"}
       \item \code{lambda = 0.001}
       \item \code{alpha = 1.0}
       \item \code{validation = 0.2}
       \item \code{lr_scheduler = config_lr_scheduler("reduce_on_plateau", patience = 7)}
       \item \code{early_stopping = 14}
     }
   }
   \item{\code{FDA.mda.fda}}{
   }
   \item{\code{GAM.gam.gam}}{
   }
   \item{\code{GAM.mgcv.bam}}{
   }
   \item{\code{GAM.mgcv.gam}}{
     \itemize{
       \item \code{method = 'GCV.Cp'}
       \item \code{control = list(epsilon = 1e-06, trace = FALSE, maxit = 100)}
     }
   }
   \item{\code{GBM.gbm.gbm}}{
     \itemize{
       \item \code{n.trees = 2500}
       \item \code{interaction.depth = 7}
       \item \code{n.minobsinnode = 5}
       \item \code{shrinkage = 0.001}
       \item \code{cv.folds = 3}
       \item \code{keep.data = FALSE}
       \item \code{n.cores = 1}
     }
   }
   \item{\code{GLM.stats.glm}}{
     \itemize{
       \item \code{mustart = 0.5}
       \item \code{control = glm.control(maxit = 50)}
     }
   }
   \item{\code{MARS.earth.earth}}{
     \itemize{
       \item \code{ncross = 0}
       \item \code{nk = NULL}
       \item \code{penalty = 2}
       \item \code{thresh = 0.001}
       \item \code{nprune = NULL}
       \item \code{pmethod = 'backward'}
     }
   }
   \item{\code{MAXENT.MAXENT.MAXENT}}{
     \itemize{
       \item \code{path_to_maxent.jar = '.'}
     }
   }
   \item{\code{RF.randomForest.randomForest}}{
     \itemize{
       \item \code{ntree = 500}
       \item \code{mtry = 2}
       \item \code{sampsize = NULL}
       \item \code{nodesize = 5}
       \item \code{maxnodes = NULL}
     }
   }
   \item{\code{RFd.randomForest.randomForest}}{
     \itemize{
       \item \code{type = 'classification'}
       \item \code{ntree = 500}
       \item \code{mtry = 2}
       \item \code{strata = factor(c(0, 1))}
       \item \code{sampsize = NULL}
       \item \code{nodesize = 5}
       \item \code{maxnodes = NULL}
     }
   }
   \item{\code{SRE.biomod2.bm_SRE}}{
     \itemize{
       \item \code{do.extrem = TRUE}
     }
   }
   \item{\code{XGBOOST.xgboost.xgboost}}{
     \itemize{
       \item \code{params = list(max_depth = 2, eta = 1, nthread = 2)}
       \item \code{nrounds = 4}
     }
   }
}
}
\usage{
OptionsBigboss
}
\description{
A \code{\link{BIOMOD.models.options}} object containing for each single model available in 
\pkg{biomod2} the parameter values pre-defined by \pkg{biomod2} team.
}
\keyword{datasets}
