% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sticker.R
\name{get_sticker}
\alias{get_sticker}
\title{Player's sticker}
\usage{
get_sticker(data_team_eff, data_team, player_sel, language = "English",
            change_hjust_perc = FALSE, size_head = c(0.4, 0.3, 5.6, 3.5), 
            size_eff = 2, size_cont_us = c(2.3, 1.7), size_plot_tit = 8)
}
\arguments{
\item{data_team_eff}{Data frame with the efficiency statistics.}

\item{data_team}{Data frame with the context and usage statistics.}

\item{player_sel}{Player of interest.}

\item{language}{Language of the titles. Valid options are 'English' and 'Spanish' so far.}

\item{change_hjust_perc}{Logical to change the position of the win percentage sentence.}

\item{size_head}{Vector with the sizes of headers text.}

\item{size_eff}{Number with the size of the efficiency text.}

\item{size_cont_us}{Vector with the sizes of context and usage text.}

\item{size_plot_tit}{Number with the size of the plot titles.}
}
\value{
A plot.
}
\description{
This function creates players' cards (a kind of sticker) that bring together 
three of the concepts considered most important in basketball analytics. These
are team efficiency (how many points the team scores and receives per possession), 
the player's shooting context (from where and with what percentage they shoot) and 
the player's use of possessions (how they end the possessions they execute).
}
\examples{
\dontrun{
# The efficiency data frame must have this type of structure:
data_team_eff <- data.frame(team = "Real Madrid", 
                            win_perc = "83.3\% (5/6)",
                            pts_poss = 1.14,
                            pts_poss_opp = 1.04)

get_sticker(data_team_eff, acb_sticker_data_2526, "A. Abalde", language = "English")
get_sticker(data_team_eff, acb_sticker_data_2526, "A. Abalde", language = "Spanish", TRUE)
}

}
\author{
Guillermo Vinue
}
