% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighting.R
\name{rake_weights}
\alias{rake_weights}
\title{Rake survey weights to match population targets}
\usage{
rake_weights(data, population_targets, weight_col = "weight")
}
\arguments{
\item{data}{A data.frame containing survey data}

\item{population_targets}{Named list with population totals for each variable}

\item{weight_col}{Character string specifying initial weight column name}
}
\value{
A data.frame with raked weights
}
\description{
This function implements simple raking (iterative proportional fitting) to adjust
survey weights to match known population marginal totals. Assumes two-dimensional
raking for simplicity.
}
\examples{
# Assuming we have gender and education population totals
targets <- list(
  gender = c(Male = 1000000, Female = 1050000),
  education = c(HighSchool = 800000, Bachelor = 900000, Graduate = 350000)
)
data <- data.frame(
  gender = c("Male", "Female", "Male", "Female", "Male"), 
  education = c("HighSchool", "Bachelor", "Bachelor", "HighSchool", "Graduate"),
  weight = c(1, 1, 1, 1, 1)
)
raked_data <- rake_weights(data, targets, "weight")
}
