% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.surrogate.extension.R
\name{test.surrogate.extension}
\alias{test.surrogate.extension}
\title{Tests whether the surrogate is valid, extended to the paired,
two sided test setting}
\usage{
test.surrogate.extension(
  yone,
  yzero,
  sone,
  szero,
  alpha = 0.05,
  power.want.s = NULL,
  epsilon = NULL,
  u.y.hyp = NULL,
  alternative = "less",
  paired = FALSE
)
}
\arguments{
\item{yone}{numeric vector of primary response values in the treated group.}

\item{yzero}{numeric vector of primary response values in the untreated group.}

\item{sone}{matrix or dataframe of surrogate candidates in the treated group
with dimension \code{n1 x p} where n1 is the number of treated samples
and p the number of candidates. Sample ordering must match exactly
\code{yone}.}

\item{szero}{matrix or dataframe of surrogate candidates in the untreated group
with dimension \code{n0 x p} where n0 is the number of untreated
samples and p the number of candidates. Sample ordering must match
exactly \code{yzero}.}

\item{alpha}{significance level for determining surrogate candidates. Default is
\code{0.05}.}

\item{power.want.s}{numeric in (0,1) - power desired for a test of treatment effect based
on the surrogate candidate. Either this or \code{epsilon} argument
must be specified.}

\item{epsilon}{numeric in (0,1) - non-inferiority margin for determining surrogate
validity. Either this or \code{power.want.s} argument must be
specified.}

\item{u.y.hyp}{hypothesised value of the treatment effect on the primary response on
the probability scale. If not given, it will be estimated based on the
observations.}

\item{alternative}{character giving the alternative hypothesis type. One of
\code{c("less","two.sided")}, where "less" corresponds to a
non-inferiority test and "two.sided" corresponds to a two one-sided
test procedure. Default is "less".}

\item{paired}{logical flag giving if the data is independent or paired. If
\code{FALSE} (default), samples are assumed independent. If
\code{TRUE}, samples are assumed to be from a paired design. The
pairs are specified by matching the rows of \code{yone} and
\code{sone} to the rows of \code{yzero} and \code{szero}.}
}
\value{
A list containing:
\itemize{
\item \code{u.y}: Estimated rank-based treatment effect on the outcome.
\item \code{u.s}: Estimated rank-based treatment effect on the surrogate.
\item \code{delta.estimate}: Estimated difference in treatment effects: \code{u.y - u.s}.
\item \code{sd.u.y}: Standard deviation of \code{u.y}.
\item \code{sd.u.s}: Standard deviation of \code{u.s}.
\item \code{sd.delta}: Standard deviation of \code{delta.estimate}.
\item \code{ci.delta}: One-sided confidence interval upper bound for \code{delta.estimate}.
\item \code{p.delta}: p-value for validity of trial-level surrogacy.
\item \code{epsilon.used}: Non-inferiority threshold used in the test.
\item \code{is.surrogate}: \code{TRUE} if the surrogate passes the test, else \code{FALSE}.
}
}
\description{
Calculates the rank-based test statistic for Y and the rank-based test statistic for S and the difference, delta, along with corresponding standard error estimates, then tests whether the surrogate is valid. This extends the \code{test.surrogate()} function to the case where samples may be paired instead of independent, and where a two sided test is desired.
}
\examples{
# Load data
data("example.data")
yone <- example.data$y1
yzero <- example.data$y0
sone <- example.data$s1
szero <- example.data$s0
test.surrogate.extension.result <- test.surrogate.extension(
  yone, yzero, sone, szero,
  power.want.s = 0.8, paired = TRUE, alternative = "two.sided"
)
}
\author{
Arthur Hughes, Layla Parast
}
