% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affairs.R
\docType{data}
\name{affairs}
\alias{affairs}
\title{Fair's Extramarital Affairs Data}
\format{
A data frame containing 601 observations on 9 variables.
\describe{
  \item{affairs}{numeric. How often engaged in extramarital sexual intercourse during the past year? 0 = none, 1 = once, 2 = twice, 3 = 3 times, 7 = 4–10 times, 12 = monthly, 12 = weekly, 12 = daily.}
  \item{gender}{factor indicating gender.}
  \item{age}{numeric variable coding age in years: 17.5 = under 20, 22 = 20–24, 27 = 25–29, 32 = 30–34, 37 = 35–39, 42 = 40–44, 47 = 45–49, 52 = 50–54, 57 = 55 or over.}
  \item{yearsmarried}{numeric variable coding number of years married: 0.125 = 3 months or less, 0.417 = 4–6 months, 0.75 = 6 months–1 year, 1.5 = 1–2 years, 4 = 3–5 years, 7 = 6–8 years, 10 = 9–11 years, 15 = 12 or more years.}
  \item{children}{factor. Are there children in the marriage?}
  \item{religiousness}{numeric variable coding religiousness: 1 = anti, 2 = not at all, 3 = slightly, 4 = somewhat, 5 = very.}
  \item{education}{numeric variable coding level of education: 9 = grade school, 12 = high school graduate, 14 = some college, 16 = college graduate, 17 = some graduate work, 18 = master's degree, 20 = Ph.D., M.D., or other advanced degree.}
  \item{occupation}{numeric variable coding occupation according to Hollingshead classification (reverse numbering).}
  \item{rating}{numeric variable coding self rating of marriage: 1 = very unhappy, 2 = somewhat unhappy, 3 = average, 4 = happier than average, 5 = very happy.}
}
}
\source{
Fair, R.C. (1978). A Theory of Extramarital Affairs. Journal of Political Economy, 86, 45–61.
}
\usage{
data(affairs)
}
\description{
Infidelity data, known as Fair's Affairs. Cross-section data from a survey conducted by Psychology Today in 1969. This dataset is sourced from the AER package.
}
\examples{
data(affairs)
summary(affairs)
}
\references{
\itemize{
  \item Greene, W.H. (2003). Econometric Analysis, 5th edition. Upper Saddle River, NJ: Prentice Hall.

\item Fair, R.C. (1978). A Theory of Extramarital Affairs. Journal of Political Economy, 86, 45–61.
}
}
\seealso{
\code{\link[AER]{Affairs}} for the original dataset in the AER package
}
\keyword{datasets}
