% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_variances_normal_gamma.R
\name{sample_variances_normal_gamma}
\alias{sample_variances_normal_gamma}
\title{Samples variances of the Normal-Gamma prior distribution by Brown & Griffin (2010).}
\usage{
sample_variances_normal_gamma(
  x,
  theta_tilde,
  zeta,
  a,
  a_vec,
  varrho0,
  varrho1,
  hyper,
  tol = 1e-06
)
}
\arguments{
\item{x}{A starting values vector of the variances. \strong{C++}: an \code{arma::vec} vector object.}

\item{theta_tilde}{A starting values vector of \eqn{\vartheta_i}. \strong{C++}:an \code{arma::vec} vector object.}

\item{zeta}{A starting value of \eqn{\zeta_j}. \strong{C++}: 
an \code{double} object.}

\item{a}{Prior shape parameter of the Gamma distribution for \eqn{\vartheta_i}. 
\strong{C++}: an \code{double} object.}

\item{a_vec}{Multinomial grid for updating shape parameter of the Gamma distribution.\strong{C++}: 
an \code{arma::vec} vector object.}

\item{varrho0}{Prior shape parameter of the Gamma distribution for \eqn{\zeta_j}. \strong{C++}: an \code{double} object.}

\item{varrho1}{Prior scale parameter of the Gamma distribution for \eqn{\zeta_j}. \strong{C++}: an \code{double} object.}

\item{hyper}{A logical value. TRUE or FALSE. \strong{C++}: an \code{bool} object}

\item{tol}{The numerical tolerance, default is '1e-06'. \strong{C++}: an \code{double} object.}
}
\value{
A vector of variances of the Normal-Gamma prior distribution. 
\strong{C++}: an \code{arma::vec} object.
}
\description{
This function samples variances from a Normal-Gamma prior distribution.
The prior distribution has a hierarchical structure where each element \eqn{x_i} of a \eqn{k}-vector \eqn{X} follows: 
\deqn{x_i \sim N(0,\vartheta_i \zeta_j), \vartheta_i \sim G(a_j, a_j / 2)
\text{, and } \zeta_j^{-1} \sim G(b,c)} for \eqn{i=j=1,\dots,k}. The hyperparameter \eqn{a_j}
follows an i.i.d. discrete hyperprior with \eqn{Pr(a_j = \tilde{a}_r) = p_r}, where
\eqn{\tilde{a} = (\tilde{a}_1, \dots, \tilde{a}_R)'} is the vector of strictly
positive support points. See Brown & Griffin (2010) and Gruber & Kastner (2025) for further details.
}
\details{
This function is based on C++ code from the R package 
\pkg{bayesianVARs} by Gruber (2025) and is using 
objects and commands from the \pkg{armadillo} library by Sanderson & Curtin (2025)
thanks to the \pkg{RcppArmadillo} package by Eddelbuettel, Francois, Bates, 
Ni, & Sanderson (2025).
}
\examples{
sample_variances_normal_gamma(rep(0,2), rep(1,2), 1, 1, rep(1,2), 1, 1, TRUE, 1e-6)

}
\references{
Gruber, L. (2025). bayesianVARs: MCMC Estimation of Bayesian Vectorautoregressions. 
R package version 0.1.5.9000, <doi: 10.32614/CRAN.package.bayesianVARs>.

Gruber, L., & Kastner, G. (2025).
Forecasting macroeconomic data with Bayesian VARs: Sparse or dense? It depends!.
International Journal of Forecasting, 41(4), 1589-1619, 
<doi:org/10.1016/j.ijforecast.2025.02.001>.

Philip J. Brown., Jim E. Griffin (2010). Inference with normal-gamma prior distributions 
in regression problems. 
Bayesian Analysis, 5(1), 171-188, <doi:org/10.1214/10-BA507>.

Eddelbuettel D., Francois R., Bates D., Ni B., Sanderson C. (2025). 
RcppArmadillo: 'Rcpp' Integration for the 'Armadillo' Templated Linear 
Algebra Library. R package version 15.0.2-2. <doi:10.32614/CRAN.package.RcppArmadillo>

Sanderson C., Curtin R. (2025). Armadillo: An Efficient Framework for 
Numerical Linear Algebra. International Conference on Computer and Automation 
Engineering, 303-307, <doi:10.1109/ICCAE64891.2025.10980539>
}
\author{
Jianying Shelly Xie \email{shellyyinggxie@gmail.com}
}
