% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Celltype_Verification_PerCell.R
\name{Celltype_Verification_PerCell}
\alias{Celltype_Verification_PerCell}
\title{Verify per-cell annotations with marker expression dotplot}
\usage{
Celltype_Verification_PerCell(
  seurat_obj,
  SlimR_percell_result,
  assay = "RNA",
  gene_number = 5,
  colour_low = "white",
  colour_high = "navy",
  annotation_col = "Cell_type_PerCell_SlimR",
  min_cells = 10
)
}
\arguments{
\item{seurat_obj}{A Seurat object with per-cell annotations.}

\item{SlimR_percell_result}{A list from Celltype_Calculate_PerCell() containing
Expression_list with marker genes per cell type.}

\item{assay}{Assay to use. Default: "RNA".}

\item{gene_number}{Number of top genes to show per cell type. Default: 5.}

\item{colour_low}{Color for lowest expression. Default: "white".}

\item{colour_high}{Color for highest expression. Default: "navy".}

\item{annotation_col}{Column in meta.data with cell type annotations.
Default: "Cell_type_PerCell_SlimR".}

\item{min_cells}{Minimum number of cells required for a cell type to be included
in the plot. Default: 10.}
}
\value{
A ggplot object showing marker gene expression dotplot.
}
\description{
This function verifies per-cell SlimR annotations by generating a dotplot
showing marker gene expression across predicted cell types.
}
\examples{
\dontrun{
# After running Celltype_Calculate_PerCell and Celltype_Annotation_PerCell
dotplot <- Celltype_Verification_PerCell(
    seurat_obj = sce,
    SlimR_percell_result = result,
    gene_number = 5,
    annotation_col = "Cell_type_PerCell_SlimR"
)
print(dotplot)
}

}
\seealso{
Other Section_3_Automated_Annotation: 
\code{\link{Celltype_Annotation}()},
\code{\link{Celltype_Annotation_PerCell}()},
\code{\link{Celltype_Calculate}()},
\code{\link{Celltype_Calculate_PerCell}()},
\code{\link{Celltype_Verification}()},
\code{\link{Parameter_Calculate}()},
\code{\link{percell_workflow}}
}
\concept{Section_3_Automated_Annotation}
