% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{extract_xponent_experiment_date}
\alias{extract_xponent_experiment_date}
\title{Extract the experiment date from xPONENT raw output}
\usage{
extract_xponent_experiment_date(xponent_output, verbose = TRUE)
}
\arguments{
\item{xponent_output}{The xPONENT output list to be processed.}

\item{verbose}{Logical, whether to print messages (default: TRUE)}
}
\value{
A character string representing the datetime of the experiment
}
\description{
This method extracts the real experiment date - BatchStartTime,
which corresponds to the time when the experiment was conducted.

The Date in the top of the xPONENT file refers to the moment when
the CSV xPONENT file was exported from the system

In case the file was parsed with an \code{exact_parse} parameter, it looks for
a parameter in a BatchMetadata list. Otherwise it tries to read it from the raw header.

In case this method fails, it fails back to read the Date from the file
}
\keyword{internal}
