% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_beta_classification.R
\name{error_beta_classification}
\alias{error_beta_classification}
\title{Compute Theoretical Bayes' Error for a Binary Gaussian Mixture}
\usage{
error_beta_classification(mu_hat, Sigma_hat, pi_hat)
}
\arguments{
\item{mu_hat}{Either a numeric matrix of size \eqn{p \times 2} whose columns
are component means, or a list of two numeric vectors.}

\item{Sigma_hat}{Numeric \eqn{p \times p} covariance matrix shared
across components.}

\item{pi_hat}{Numeric vector of length 2 with mixing proportions
\eqn{(\pi_1, \pi_2)} that are non-negative and sum to 1.}
}
\value{
A numeric scalar giving the theoretical Bayes' classification error rate.
}
\description{
Computes the Bayes'classification error rate for a two-component Gaussian
mixture given \code{mu_hat}, \code{Sigma_hat}, and \code{pi_hat}. If
\code{mu_hat} is supplied as a list of length 2, it is converted to a
\eqn{p \times 2} matrix internally.
}
\details{
The linear discriminant is
\deqn{
  \beta_1 = \Sigma^{-1}(\mu_1 - \mu_2), \qquad
  \beta_0 = -\frac{1}{2}(\mu_1 + \mu_2)^\top \Sigma^{-1}(\mu_1 - \mu_2)
           + \log(\pi_1 / \pi_2)
}
and the Bayes' error is
\deqn{
  \mathrm{Err}
  = \sum_{k = 1}^2 \pi_k \,
    \Phi\left(
      \frac{(-1)^k \{\beta_0 + \beta_1^\top \mu_k\}}
           {\|\beta_1\|}
    \right),
}
where \eqn{\Phi} is the standard normal cdf.
}
\examples{
mu_hat <- matrix(c(1, 0, -1, 0), nrow = 2)  # columns are mu1, mu2
Sigma_hat <- diag(2)
pi_hat <- c(0.5, 0.5)
error_beta_classification(mu_hat, Sigma_hat, pi_hat)

}
